/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.lang.reflect.Method;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanPropertyWriter {
    final String _name;
    final Method _accessorMethod;
    final JsonSerializer<Object> _serializer;

    public BeanPropertyWriter(String name, Method acc, JsonSerializer<Object> ser) {
        this._name = name;
        this._accessorMethod = acc;
        this._serializer = ser;
    }

    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new BeanPropertyWriter(this._name, this._accessorMethod, ser);
    }

    public boolean hasSerializer() {
        return this._serializer != null;
    }

    public final Class<?> getReturnType() {
        return this._accessorMethod.getReturnType();
    }

    public final String getName() {
        return this._name;
    }

    public String toString() {
        return "property '" + this.getName() + "' (via method " + this._accessorMethod.getDeclaringClass() + "#" + this._accessorMethod.getName() + "))";
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        JsonSerializer<Object> ser;
        Object value = this._accessorMethod.invoke(bean, new Object[0]);
        if (value == null) {
            ser = prov.getNullValueSerializer();
        } else {
            ser = this._serializer;
            if (ser == null) {
                ser = prov.findValueSerializer(value.getClass());
            }
        }
        jgen.writeFieldName(this._name);
        ser.serialize(value, jgen, prov);
    }
}

