/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.deser;

import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.DeserializerFactory;
import org.codehaus.jackson.map.DeserializerProvider;
import org.codehaus.jackson.map.JsonDeserializer;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.KeyDeserializer;
import org.codehaus.jackson.map.ResolvableDeserializer;
import org.codehaus.jackson.map.deser.BeanDeserializerFactory;
import org.codehaus.jackson.map.deser.StdDeserializers;
import org.codehaus.jackson.map.deser.StdKeyDeserializers;
import org.codehaus.jackson.map.type.ArrayType;
import org.codehaus.jackson.map.type.CollectionType;
import org.codehaus.jackson.map.type.MapType;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.map.util.ClassUtil;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StdDeserializerProvider
extends DeserializerProvider {
    static final JavaType _typeObject = TypeFactory.fromClass(Object.class);
    static final JavaType _typeString = TypeFactory.fromClass(String.class);
    static final HashMap<JavaType, JsonDeserializer<Object>> _simpleDeserializers = StdDeserializers.constructAll();
    static final HashMap<JavaType, KeyDeserializer> _keyDeserializers = StdKeyDeserializers.constructAll();
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _cachedDeserializers = new ConcurrentHashMap(64, 0.75f, 2);
    DeserializerFactory _factory;

    public StdDeserializerProvider() {
        this(BeanDeserializerFactory.instance);
    }

    public StdDeserializerProvider(DeserializerFactory f) {
        this._factory = f;
    }

    @Override
    public JsonDeserializer<Object> findValueDeserializer(JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        JsonDeserializer<Object> deser = this._findSimpleDeserializer(type);
        if (deser != null) {
            return deser;
        }
        deser = this._findCachedDeserializer(type);
        if (deser != null) {
            return deser;
        }
        deser = this._createAndCacheValueDeserializer(type, referrer, refPropName);
        if (deser == null) {
            deser = this._handleUnknownValueDeserializer(type);
        }
        return deser;
    }

    @Override
    public KeyDeserializer findKeyDeserializer(JavaType type) {
        if (_typeString.equals((Object)type) || _typeObject.equals((Object)type)) {
            return null;
        }
        KeyDeserializer kdes = _keyDeserializers.get(type);
        if (kdes != null) {
            return kdes;
        }
        if (type.isEnumType()) {
            return StdKeyDeserializers.constructEnumKeyDeserializer(type);
        }
        kdes = StdKeyDeserializers.findStringBasedKeyDeserializer(type);
        if (kdes != null) {
            return kdes;
        }
        return this._handleUnknownKeyDeserializer(type);
    }

    @Override
    public boolean hasValueDeserializerFor(JavaType type) {
        JsonDeserializer<Object> deser = this._findSimpleDeserializer(type);
        if (deser == null && (deser = this._findCachedDeserializer(type)) == null) {
            try {
                deser = this._createAndCacheValueDeserializer(type, null, null);
            }
            catch (Exception e) {
                return false;
            }
        }
        return deser != null;
    }

    protected JsonDeserializer<Object> _findSimpleDeserializer(JavaType type) {
        return _simpleDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _findCachedDeserializer(JavaType type) {
        return this._cachedDeserializers.get(type);
    }

    protected JsonDeserializer<Object> _createAndCacheValueDeserializer(JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        JsonDeserializer<Object> deser;
        try {
            deser = this._createDeserializer(type, referrer, refPropName);
        }
        catch (IllegalArgumentException iae) {
            throw new JsonMappingException(iae.getMessage(), null, iae);
        }
        if (deser != null) {
            if (deser instanceof ResolvableDeserializer) {
                this._cachedDeserializers.put(type, deser);
                this._resolveDeserializer((ResolvableDeserializer)((Object)deser));
            } else if (type.isEnumType()) {
                this._cachedDeserializers.put(type, deser);
            }
        }
        return deser;
    }

    protected JsonDeserializer<Object> _createDeserializer(JavaType type, JavaType referrer, String refPropName) throws JsonMappingException {
        if (type.isEnumType()) {
            return this._factory.createEnumDeserializer(type.getRawClass(), this);
        }
        if (type instanceof ArrayType) {
            return this._factory.createArrayDeserializer((ArrayType)type, this);
        }
        if (type instanceof MapType) {
            return this._factory.createMapDeserializer((MapType)type, this);
        }
        if (type instanceof CollectionType) {
            return this._factory.createCollectionDeserializer((CollectionType)type, this);
        }
        Class rawClass = type.getRawClass();
        if (JsonNode.class.isAssignableFrom(rawClass)) {
            Class nodeClass = rawClass;
            return this._factory.createTreeDeserializer(nodeClass, this);
        }
        return this._factory.createBeanDeserializer(type, this);
    }

    protected void _resolveDeserializer(ResolvableDeserializer ser) throws JsonMappingException {
        ser.resolve(this);
    }

    protected JsonDeserializer<Object> _handleUnknownValueDeserializer(JavaType type) {
        Class rawClass = type.getRawClass();
        if (!ClassUtil.isConcrete(rawClass)) {
            throw new IllegalArgumentException("Can not find a Value deserializer for abstract type " + type);
        }
        throw new IllegalArgumentException("Can not find a Value deserializer for type " + type);
    }

    protected KeyDeserializer _handleUnknownKeyDeserializer(JavaType type) {
        throw new IllegalArgumentException("Can not find a (Map) Key deserializer for type " + type);
    }
}

