/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.ResolvableSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.WritableBeanProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BeanSerializer
extends JsonSerializer<Object>
implements ResolvableSerializer {
    final String _className;
    final WritableBeanProperty[] _props;

    public BeanSerializer(Class<?> type, WritableBeanProperty[] props) {
        if (props.length == 0) {
            throw new IllegalArgumentException("Can not create BeanSerializer for type that has no properties");
        }
        this._props = props;
        this._className = type.getName();
    }

    public BeanSerializer(Class<?> type, Collection<WritableBeanProperty> props) {
        this(type, props.toArray(new WritableBeanProperty[props.size()]));
    }

    @Override
    public void serialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonGenerationException {
        int i;
        jgen.writeStartObject();
        try {
            int len = this._props.length;
            for (i = 0; i < len; ++i) {
                this._props[i].serializeAsField(bean, jgen, provider);
            }
        }
        catch (IllegalAccessException e1) {
            throw new JsonGenerationException("Failed to serialize " + this._props[i] + ": " + e1.getMessage(), (Throwable)e1);
        }
        catch (InvocationTargetException e2) {
            throw new JsonGenerationException("Failed to serialize " + this._props[i] + ": " + e2.getMessage(), (Throwable)e2);
        }
        jgen.writeEndObject();
    }

    @Override
    public void resolve(SerializerProvider provider) {
        for (WritableBeanProperty prop : this._props) {
            Class<?> rt;
            if (prop.hasSerializer() || !Modifier.isFinal((rt = prop.getReturnType()).getModifiers())) continue;
            JsonSerializer<Object> ser = provider.findValueSerializer(rt);
            prop.assignSerializer(ser);
        }
    }

    public String toString() {
        return "BeanSerializer for " + this._className;
    }
}

