/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

import org.codehaus.jackson.ArrayWContext;
import org.codehaus.jackson.ObjectWContext;
import org.codehaus.jackson.RootWContext;

public abstract class JsonWriteContext {
    public static final int STATUS_OK_AS_IS = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_OK_AFTER_SPACE = 3;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    protected final JsonWriteContext mParent;
    protected int mIndex;
    JsonWriteContext mChildArray = null;
    JsonWriteContext mChildObject = null;

    public JsonWriteContext(JsonWriteContext parent) {
        this.mParent = parent;
        this.mIndex = -1;
    }

    public static JsonWriteContext createRootContext() {
        return new RootWContext();
    }

    public final JsonWriteContext createChildArrayContext() {
        JsonWriteContext ctxt = this.mChildArray;
        if (ctxt == null) {
            this.mChildArray = ctxt = new ArrayWContext(this);
        } else {
            ctxt.mIndex = -1;
        }
        return ctxt;
    }

    public final JsonWriteContext createChildObjectContext() {
        JsonWriteContext ctxt = this.mChildObject;
        if (ctxt == null) {
            this.mChildObject = ctxt = new ObjectWContext(this);
        } else {
            ctxt.mIndex = -1;
        }
        return ctxt;
    }

    public final JsonWriteContext getParent() {
        return this.mParent;
    }

    public final boolean isRoot() {
        return this.mParent == null;
    }

    public final int getEntryCount() {
        return this.mIndex + 1;
    }

    public final int getCurrentIndex() {
        return this.mIndex < 0 ? 0 : this.mIndex;
    }

    public abstract Type getType();

    public abstract int writeFieldName(String var1);

    public abstract int writeValue();

    public boolean inArray() {
        return false;
    }

    public boolean inObject() {
        return false;
    }

    protected abstract void appendDesc(StringBuilder var1);

    public final String toString() {
        StringBuilder sb = new StringBuilder(64);
        this.appendDesc(sb);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        ROOT,
        OBJECT,
        ARRAY;

    }
}

