/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson;

public class JsonLocation {
    final long mTotalChars;
    final int mLineNr;
    final int mColumnNr;
    final Object mSourceRef;

    public JsonLocation(Object srcRef, long totalChars, int lineNr, int colNr) {
        this.mTotalChars = totalChars;
        this.mLineNr = lineNr;
        this.mColumnNr = colNr;
        this.mSourceRef = srcRef;
    }

    public Object getSourceRef() {
        return this.mSourceRef;
    }

    public int getLineNr() {
        return this.mLineNr;
    }

    public int getColumnNr() {
        return this.mColumnNr;
    }

    public long getCharOffset() {
        return this.mTotalChars;
    }

    public long getByteOffset() {
        return -1L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("[Source: ");
        if (this.mSourceRef == null) {
            sb.append("UNKNOWN");
        } else {
            sb.append(this.mSourceRef.toString());
        }
        sb.append("; line: ");
        sb.append(this.mLineNr);
        sb.append(", column: ");
        sb.append(this.mColumnNr);
        sb.append(']');
        return sb.toString();
    }
}

