/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.jaxrs;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;
import org.codehaus.jackson.type.JavaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JacksonJsonProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    protected final ContextResolver<ObjectMapper> _resolver;
    protected boolean _cfgCheckCanSerialize = false;
    protected boolean _cfgCheckCanDeserialize = false;

    public JacksonJsonProvider() {
        this(new ObjectMapper());
    }

    public JacksonJsonProvider(ObjectMapper mapper) {
        this._resolver = new SingleContextResolver<ObjectMapper>(mapper);
    }

    public JacksonJsonProvider(@Context Providers providers) {
        SingleContextResolver<ObjectMapper> resolver = providers == null ? null : providers.getContextResolver(ObjectMapper.class, null);
        if (resolver == null) {
            ObjectMapper mapper = new ObjectMapper();
            resolver = new SingleContextResolver<ObjectMapper>(mapper);
        }
        this._resolver = resolver;
    }

    public void checkCanDeserialize(boolean state) {
        this._cfgCheckCanDeserialize = state;
    }

    public void checkCanSerialize(boolean state) {
        this._cfgCheckCanSerialize = state;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ObjectMapper mapper;
        if (!MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || (mapper = (ObjectMapper)this._resolver.getContext(type)).canDeserialize(this._convertType(type));
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        ObjectMapper mapper = (ObjectMapper)this._resolver.getContext(type);
        JsonParser jp = mapper.getJsonFactory().createJsonParser(entityStream);
        jp.disableFeature(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return mapper.readValue(jp, this._convertType(genericType));
    }

    public long getSize(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        ObjectMapper mapper;
        if (!MediaType.APPLICATION_JSON_TYPE.equals((Object)mediaType)) {
            return false;
        }
        return !this._cfgCheckCanSerialize || (mapper = (ObjectMapper)this._resolver.getContext(type)).canSerialize(type);
    }

    public void writeTo(Object value, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        ObjectMapper mapper = (ObjectMapper)this._resolver.getContext(type);
        JsonGenerator jg = mapper.getJsonFactory().createJsonGenerator(entityStream, JsonEncoding.UTF8);
        jg.disableFeature(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        mapper.writeValue(jg, value);
    }

    protected JavaType _convertType(Type jdkType) {
        return TypeFactory.fromType((Type)jdkType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SingleContextResolver<T>
    implements ContextResolver<T> {
        private final T _singleton;

        public SingleContextResolver(T s) {
            this._singleton = s;
        }

        public T getContext(Class<?> cls) {
            return this._singleton;
        }
    }
}

