/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import org.codehaus.jackson.util.BufferRecycler;

public final class TextBuffer {
    static final char[] NO_CHARS = new char[0];
    private final BufferRecycler mAllocator;
    private char[] mInputBuffer;
    private int mInputStart;
    private int mInputLen;
    private ArrayList<char[]> mSegments;
    private boolean mHasSegments = false;
    private int mSegmentSize;
    private char[] mCurrentSegment;
    private int mCurrentSize;
    private String mResultString;
    private char[] mResultArray;

    public TextBuffer(BufferRecycler allocator) {
        this.mAllocator = allocator;
    }

    public void releaseBuffers() {
        if (this.mAllocator != null && this.mCurrentSegment != null) {
            this.resetWithEmpty();
            char[] buf = this.mCurrentSegment;
            this.mCurrentSegment = null;
            this.mAllocator.releaseCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, buf);
        }
    }

    public void resetWithEmpty() {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
        this.mCurrentSize = 0;
    }

    public void resetWithShared(char[] buf, int start, int len) {
        this.mResultString = null;
        this.mResultArray = null;
        this.mInputBuffer = buf;
        this.mInputStart = start;
        this.mInputLen = len;
        if (this.mHasSegments) {
            this.clearSegments();
        }
    }

    public void resetWithCopy(char[] buf, int start, int len) {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = null;
        this.mResultArray = null;
        if (this.mHasSegments) {
            this.clearSegments();
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
        this.append(buf, start, len);
    }

    public void resetWithString(String str) {
        this.mInputBuffer = null;
        this.mInputStart = -1;
        this.mInputLen = 0;
        this.mResultString = str;
        this.mResultArray = null;
        int len = str.length();
        if (this.mHasSegments) {
            this.mCurrentSegment = this.mSegments.get(this.mSegments.size() - 1);
            this.mSegments.clear();
        } else if (this.mCurrentSegment == null) {
            this.mCurrentSegment = this.allocBuffer(len);
        }
        if (this.mCurrentSegment.length < len) {
            this.mCurrentSegment = new char[len];
        }
        str.getChars(0, len, this.mCurrentSegment, 0);
        this.mCurrentSize = len;
    }

    private final char[] allocBuffer(int needed) {
        return this.mAllocator.allocCharBuffer(BufferRecycler.CharBufferType.TEXT_BUFFER, needed);
    }

    private final void clearSegments() {
        this.mHasSegments = false;
        this.mCurrentSegment = this.mSegments.get(this.mSegments.size() - 1);
        this.mSegments.clear();
        this.mSegmentSize = 0;
        this.mCurrentSize = 0;
    }

    public int size() {
        if (this.mInputStart >= 0) {
            return this.mInputLen;
        }
        return this.mSegmentSize + this.mCurrentSize;
    }

    public int getTextOffset() {
        return this.mInputStart >= 0 ? this.mInputStart : 0;
    }

    public char[] getTextBuffer() {
        if (this.mInputStart >= 0) {
            return this.mInputBuffer;
        }
        if (!this.mHasSegments) {
            return this.mCurrentSegment;
        }
        return this.contentsAsArray();
    }

    public String contentsAsString() {
        if (this.mResultString == null) {
            if (this.mResultArray != null) {
                this.mResultString = new String(this.mResultArray);
            } else if (this.mInputStart >= 0) {
                if (this.mInputLen < 1) {
                    this.mResultString = "";
                    return "";
                }
                this.mResultString = new String(this.mInputBuffer, this.mInputStart, this.mInputLen);
            } else {
                int segLen = this.mSegmentSize;
                int currLen = this.mCurrentSize;
                if (segLen == 0) {
                    this.mResultString = currLen == 0 ? "" : new String(this.mCurrentSegment, 0, currLen);
                } else {
                    StringBuilder sb = new StringBuilder(segLen + currLen);
                    if (this.mSegments != null) {
                        int len = this.mSegments.size();
                        for (int i = 0; i < len; ++i) {
                            char[] curr = this.mSegments.get(i);
                            sb.append(curr, 0, curr.length);
                        }
                    }
                    sb.append(this.mCurrentSegment, 0, this.mCurrentSize);
                    this.mResultString = sb.toString();
                }
            }
        }
        return this.mResultString;
    }

    public char[] contentsAsArray() {
        char[] result = this.mResultArray;
        if (result == null) {
            this.mResultArray = result = this.buildResultArray();
        }
        return result;
    }

    public int contentsToArray(int srcStart, char[] dst, int dstStart, int len) {
        if (this.mInputStart >= 0) {
            int amount = this.mInputLen - srcStart;
            if (amount > len) {
                amount = len;
            } else if (amount < 0) {
                amount = 0;
            }
            if (amount > 0) {
                System.arraycopy(this.mInputBuffer, this.mInputStart + srcStart, dst, dstStart, amount);
            }
            return amount;
        }
        int totalAmount = 0;
        if (this.mSegments != null) {
            int segc = this.mSegments.size();
            for (int i = 0; i < segc; ++i) {
                char[] segment = this.mSegments.get(i);
                int segLen = segment.length;
                int amount = segLen - srcStart;
                if (amount < 1) {
                    srcStart -= segLen;
                    continue;
                }
                if (amount >= len) {
                    System.arraycopy(segment, srcStart, dst, dstStart, len);
                    return totalAmount + len;
                }
                System.arraycopy(segment, srcStart, dst, dstStart, amount);
                totalAmount += amount;
                dstStart += amount;
                len -= amount;
                srcStart = 0;
            }
        }
        if (len > 0) {
            int maxAmount = this.mCurrentSize - srcStart;
            if (len > maxAmount) {
                len = maxAmount;
            }
            if (len > 0) {
                System.arraycopy(this.mCurrentSegment, srcStart, dst, dstStart, len);
                totalAmount += len;
            }
        }
        return totalAmount;
    }

    public int rawContentsTo(Writer w) throws IOException {
        if (this.mResultArray != null) {
            w.write(this.mResultArray);
            return this.mResultArray.length;
        }
        if (this.mResultString != null) {
            w.write(this.mResultString);
            return this.mResultString.length();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen > 0) {
                w.write(this.mInputBuffer, this.mInputStart, this.mInputLen);
            }
            return this.mInputLen;
        }
        int rlen = 0;
        if (this.mSegments != null) {
            int len = this.mSegments.size();
            for (int i = 0; i < len; ++i) {
                char[] ch = this.mSegments.get(i);
                w.write(ch);
                rlen += ch.length;
            }
        }
        if (this.mCurrentSize > 0) {
            w.write(this.mCurrentSegment, 0, this.mCurrentSize);
            rlen += this.mCurrentSize;
        }
        return rlen;
    }

    public BigDecimal contentsAsDecimal() throws NumberFormatException {
        if (this.mResultArray != null) {
            return new BigDecimal(this.mResultArray);
        }
        if (this.mInputStart >= 0) {
            return new BigDecimal(this.mInputBuffer, this.mInputStart, this.mInputLen);
        }
        if (this.mSegmentSize == 0) {
            return new BigDecimal(this.mCurrentSegment, 0, this.mCurrentSize);
        }
        return new BigDecimal(this.contentsAsArray());
    }

    public double contentsAsDouble() throws NumberFormatException {
        return Double.parseDouble(this.contentsAsString());
    }

    public void ensureNotShared() {
        if (this.mInputStart >= 0) {
            this.unshare(16);
        }
    }

    public void append(char[] c, int start, int len) {
        if (this.mInputStart >= 0) {
            this.unshare(len);
        }
        this.mResultString = null;
        this.mResultArray = null;
        char[] curr = this.mCurrentSegment;
        int max = curr.length - this.mCurrentSize;
        if (max >= len) {
            System.arraycopy(c, start, curr, this.mCurrentSize, len);
            this.mCurrentSize += len;
        } else {
            if (max > 0) {
                System.arraycopy(c, start, curr, this.mCurrentSize, max);
                start += max;
                len -= max;
            }
            this.expand(len);
            System.arraycopy(c, start, this.mCurrentSegment, 0, len);
            this.mCurrentSize = len;
        }
    }

    public char[] getCurrentSegment() {
        if (this.mInputStart >= 0) {
            this.unshare(1);
        } else {
            char[] curr = this.mCurrentSegment;
            if (curr == null) {
                this.mCurrentSegment = this.allocBuffer(0);
            } else if (this.mCurrentSize >= curr.length) {
                this.expand(1);
            }
        }
        return this.mCurrentSegment;
    }

    public char[] emptyAndGetCurrentSegment() {
        this.resetWithEmpty();
        char[] curr = this.mCurrentSegment;
        if (curr == null) {
            this.mCurrentSegment = curr = this.allocBuffer(0);
        }
        return curr;
    }

    public int getCurrentSegmentSize() {
        return this.mCurrentSize;
    }

    public void setCurrentLength(int len) {
        this.mCurrentSize = len;
    }

    public char[] finishCurrentSegment() {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        this.mHasSegments = true;
        this.mSegments.add(this.mCurrentSegment);
        int oldLen = this.mCurrentSegment.length;
        this.mSegmentSize += oldLen;
        char[] curr = new char[oldLen + (oldLen >> 1)];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
        return curr;
    }

    public char[] expandCurrentSegment() {
        char[] curr = this.mCurrentSegment;
        int len = curr.length;
        this.mCurrentSegment = new char[len + len];
        System.arraycopy(curr, 0, this.mCurrentSegment, 0, len);
        return this.mCurrentSegment;
    }

    public String toString() {
        return this.contentsAsString();
    }

    private void unshare(int needExtra) {
        int sharedLen = this.mInputLen;
        this.mInputLen = 0;
        char[] inputBuf = this.mInputBuffer;
        this.mInputBuffer = null;
        int start = this.mInputStart;
        this.mInputStart = -1;
        int needed = sharedLen + needExtra;
        if (this.mCurrentSegment == null || needed > this.mCurrentSegment.length) {
            this.mCurrentSegment = this.allocBuffer(needed);
        }
        if (sharedLen > 0) {
            System.arraycopy(inputBuf, start, this.mCurrentSegment, 0, sharedLen);
        }
        this.mSegmentSize = 0;
        this.mCurrentSize = sharedLen;
    }

    private void expand(int minNewSegmentSize) {
        if (this.mSegments == null) {
            this.mSegments = new ArrayList();
        }
        char[] curr = this.mCurrentSegment;
        this.mHasSegments = true;
        this.mSegments.add(curr);
        this.mSegmentSize += curr.length;
        int oldLen = curr.length;
        int sizeAddition = oldLen >> 1;
        if (sizeAddition < minNewSegmentSize) {
            sizeAddition = minNewSegmentSize;
        }
        curr = new char[oldLen + sizeAddition];
        this.mCurrentSize = 0;
        this.mCurrentSegment = curr;
    }

    private char[] buildResultArray() {
        char[] result;
        if (this.mResultString != null) {
            return this.mResultString.toCharArray();
        }
        if (this.mInputStart >= 0) {
            if (this.mInputLen < 1) {
                return NO_CHARS;
            }
            result = new char[this.mInputLen];
            System.arraycopy(this.mInputBuffer, this.mInputStart, result, 0, this.mInputLen);
        } else {
            int size = this.size();
            if (size < 1) {
                return NO_CHARS;
            }
            int offset = 0;
            result = new char[size];
            if (this.mSegments != null) {
                int len = this.mSegments.size();
                for (int i = 0; i < len; ++i) {
                    char[] curr = this.mSegments.get(i);
                    int currLen = curr.length;
                    System.arraycopy(curr, 0, result, offset, currLen);
                    offset += currLen;
                }
            }
            System.arraycopy(this.mCurrentSegment, 0, result, offset, this.mCurrentSize);
        }
        return result;
    }
}

