/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.util;

public final class SymbolTable {
    protected static final int DEFAULT_TABLE_SIZE = 64;
    protected static final boolean INTERN_STRINGS = true;
    static final int MAX_SYMBOL_TABLE_SIZE = 6000;
    static final SymbolTable sBootstrapSymbolTable = new SymbolTable(64);
    protected SymbolTable mParent;
    protected String[] mSymbols;
    protected Bucket[] mBuckets;
    protected int mSize;
    protected int mSizeThreshold;
    protected int mIndexMask;
    protected boolean mDirty;

    public static SymbolTable createRoot() {
        return sBootstrapSymbolTable.makeOrphan();
    }

    public SymbolTable() {
        this(64);
    }

    public SymbolTable(int initialSize) {
        int currSize;
        this.mDirty = true;
        if (initialSize < 1) {
            throw new IllegalArgumentException("Can not use negative/zero initial size: " + initialSize);
        }
        for (currSize = 4; currSize < initialSize; currSize += currSize) {
        }
        initialSize = currSize;
        this.initTables(initialSize);
    }

    private void initTables(int initialSize) {
        this.mSymbols = new String[initialSize];
        this.mBuckets = new Bucket[initialSize >> 1];
        this.mIndexMask = initialSize - 1;
        this.mSize = 0;
        this.mSizeThreshold = initialSize - (initialSize >> 2);
    }

    private SymbolTable(SymbolTable parent, String[] symbols, Bucket[] buckets, int size) {
        this.mParent = parent;
        this.mSymbols = symbols;
        this.mBuckets = buckets;
        this.mSize = size;
        int arrayLen = symbols.length;
        this.mSizeThreshold = arrayLen - (arrayLen >> 2);
        this.mIndexMask = arrayLen - 1;
        this.mDirty = false;
    }

    public synchronized SymbolTable makeChild() {
        return new SymbolTable(this, this.mSymbols, this.mBuckets, this.mSize);
    }

    private SymbolTable makeOrphan() {
        return new SymbolTable(null, this.mSymbols, this.mBuckets, this.mSize);
    }

    private synchronized void mergeChild(SymbolTable child) {
        if (child.size() > 6000) {
            this.initTables(64);
        } else {
            if (child.size() <= this.size()) {
                return;
            }
            this.mSymbols = child.mSymbols;
            this.mBuckets = child.mBuckets;
            this.mSize = child.mSize;
            this.mSizeThreshold = child.mSizeThreshold;
            this.mIndexMask = child.mIndexMask;
        }
        this.mDirty = false;
    }

    public void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this.mParent != null) {
            this.mParent.mergeChild(this);
            this.mDirty = false;
        }
    }

    public int size() {
        return this.mSize;
    }

    public boolean maybeDirty() {
        return this.mDirty;
    }

    public String findSymbol(char[] buffer, int start, int len, int hash) {
        if (len < 1) {
            return "";
        }
        String sym = this.mSymbols[hash &= this.mIndexMask];
        if (sym != null) {
            Bucket b;
            if (sym.length() == len) {
                int i = 0;
                while (sym.charAt(i) == buffer[start + i] && ++i < len) {
                }
                if (i == len) {
                    return sym;
                }
            }
            if ((b = this.mBuckets[hash >> 1]) != null && (sym = b.find(buffer, start, len)) != null) {
                return sym;
            }
        }
        if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        } else if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            hash = SymbolTable.calcHash(buffer, start, len) & this.mIndexMask;
        }
        ++this.mSize;
        String newSymbol = new String(buffer, start, len);
        newSymbol = newSymbol.intern();
        if (this.mSymbols[hash] == null) {
            this.mSymbols[hash] = newSymbol;
        } else {
            int bix = hash >> 1;
            this.mBuckets[bix] = new Bucket(newSymbol, this.mBuckets[bix]);
        }
        return newSymbol;
    }

    public String findSymbol(String str) {
        int len = str.length();
        if (len < 1) {
            return "";
        }
        int index = SymbolTable.calcHash(str) & this.mIndexMask;
        String sym = this.mSymbols[index];
        if (sym != null) {
            Bucket b;
            if (sym.length() == len) {
                int i;
                for (i = 0; i < len && sym.charAt(i) == str.charAt(i); ++i) {
                }
                if (i == len) {
                    return sym;
                }
            }
            if ((b = this.mBuckets[index >> 1]) != null && (sym = b.find(str)) != null) {
                return sym;
            }
        }
        if (this.mSize >= this.mSizeThreshold) {
            this.rehash();
            index = SymbolTable.calcHash(str) & this.mIndexMask;
        } else if (!this.mDirty) {
            this.copyArrays();
            this.mDirty = true;
        }
        ++this.mSize;
        str = str.intern();
        if (this.mSymbols[index] == null) {
            this.mSymbols[index] = str;
        } else {
            int bix = index >> 1;
            this.mBuckets[bix] = new Bucket(str, this.mBuckets[bix]);
        }
        return str;
    }

    public static int calcHash(char[] buffer, int start, int len) {
        int hash = buffer[0];
        for (int i = 1; i < len; ++i) {
            hash = hash * 31 + buffer[i];
        }
        return hash;
    }

    public static int calcHash(String key) {
        int hash = key.charAt(0);
        int len = key.length();
        for (int i = 1; i < len; ++i) {
            hash = hash * 31 + key.charAt(i);
        }
        return hash;
    }

    private void copyArrays() {
        String[] oldSyms = this.mSymbols;
        int size = oldSyms.length;
        this.mSymbols = new String[size];
        System.arraycopy(oldSyms, 0, this.mSymbols, 0, size);
        Bucket[] oldBuckets = this.mBuckets;
        size = oldBuckets.length;
        this.mBuckets = new Bucket[size];
        System.arraycopy(oldBuckets, 0, this.mBuckets, 0, size);
    }

    private void rehash() {
        int i;
        int size = this.mSymbols.length;
        int newSize = size + size;
        String[] oldSyms = this.mSymbols;
        Bucket[] oldBuckets = this.mBuckets;
        this.mSymbols = new String[newSize];
        this.mBuckets = new Bucket[newSize >> 1];
        this.mIndexMask = newSize - 1;
        this.mSizeThreshold += this.mSizeThreshold;
        int count = 0;
        for (i = 0; i < size; ++i) {
            String symbol = oldSyms[i];
            if (symbol == null) continue;
            ++count;
            int index = SymbolTable.calcHash(symbol) & this.mIndexMask;
            if (this.mSymbols[index] == null) {
                this.mSymbols[index] = symbol;
                continue;
            }
            int bix = index >> 1;
            this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
        }
        size >>= 1;
        for (i = 0; i < size; ++i) {
            for (Bucket b = oldBuckets[i]; b != null; b = b.getNext()) {
                ++count;
                String symbol = b.getSymbol();
                int index = SymbolTable.calcHash(symbol) & this.mIndexMask;
                if (this.mSymbols[index] == null) {
                    this.mSymbols[index] = symbol;
                    continue;
                }
                int bix = index >> 1;
                this.mBuckets[bix] = new Bucket(symbol, this.mBuckets[bix]);
            }
        }
        if (count != this.mSize) {
            throw new Error("Internal error on SymbolTable.rehash(): had " + this.mSize + " entries; now have " + count + ".");
        }
    }

    static final class Bucket {
        private final String mSymbol;
        private final Bucket mNext;

        public Bucket(String symbol, Bucket next) {
            this.mSymbol = symbol;
            this.mNext = next;
        }

        public String getSymbol() {
            return this.mSymbol;
        }

        public Bucket getNext() {
            return this.mNext;
        }

        public String find(char[] buf, int start, int len) {
            String sym = this.mSymbol;
            Bucket b = this.mNext;
            while (true) {
                if (sym.length() == len) {
                    int i = 0;
                    while (sym.charAt(i) == buf[start + i] && ++i < len) {
                    }
                    if (i == len) {
                        return sym;
                    }
                }
                if (b == null) break;
                sym = b.getSymbol();
                b = b.getNext();
            }
            return null;
        }

        public String find(String str) {
            String sym = this.mSymbol;
            Bucket b = this.mNext;
            while (true) {
                if (sym.equals(str)) {
                    return sym;
                }
                if (b == null) break;
                sym = b.getSymbol();
                b = b.getNext();
            }
            return null;
        }
    }
}

