/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver.ning;

import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import com.ning.http.client.BodyGenerator;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Response;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;
import org.codehaus.httpcache4j.resolver.ConnectionConfiguration;
import org.codehaus.httpcache4j.resolver.ResolverConfiguration;
import org.codehaus.httpcache4j.resolver.ResponseCreator;

public class NingResponseResolver
extends AbstractResponseResolver {
    private final AsyncHttpClient client;

    protected NingResponseResolver(ResolverConfiguration configuration, AsyncHttpClientConfig asyncConfig) {
        super(configuration);
        AsyncHttpClientConfig.Builder config = new AsyncHttpClientConfig.Builder(Objects.requireNonNull(asyncConfig, "Async config may not be null")).setUserAgent(configuration.getUserAgent());
        config.setAllowPoolingConnections(true);
        config.setFollowRedirect(false);
        ConnectionConfiguration connectionConfiguration = this.configureConnections(configuration, config);
        if (!connectionConfiguration.getConnectionsPerHost().isEmpty()) {
            throw new UnsupportedOperationException("This Resolver does not support connections per host");
        }
        this.client = new AsyncHttpClient(config.build());
    }

    private ConnectionConfiguration configureConnections(ResolverConfiguration configuration, AsyncHttpClientConfig.Builder config) {
        ConnectionConfiguration connectionConfiguration = configuration.getConnectionConfiguration();
        if (connectionConfiguration.getMaxConnections().isPresent()) {
            config.setMaxConnections(((Integer)connectionConfiguration.getMaxConnections().get()).intValue());
        }
        if (connectionConfiguration.getDefaultConnectionsPerHost().isPresent()) {
            config.setMaxConnectionsPerHost(((Integer)connectionConfiguration.getDefaultConnectionsPerHost().get()).intValue());
        }
        if (connectionConfiguration.getTimeout().isPresent()) {
            config.setReadTimeout(((Integer)connectionConfiguration.getTimeout().get()).intValue());
        }
        if (connectionConfiguration.getSocketTimeout().isPresent()) {
            config.setConnectTimeout(((Integer)connectionConfiguration.getSocketTimeout().get()).intValue());
        }
        return connectionConfiguration;
    }

    public NingResponseResolver(ResolverConfiguration configuration) {
        this(configuration, new AsyncHttpClientConfig.Builder().build());
    }

    public NingResponseResolver(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        this(new ResolverConfiguration(proxyAuthenticator, authenticator, new ConnectionConfiguration()));
    }

    public static NingResponseResolver newInstance(ResolverConfiguration configuration) {
        return new NingResponseResolver(configuration);
    }

    public static NingResponseResolver newInstance(ConnectionConfiguration configuration) {
        return NingResponseResolver.newInstance(new ResolverConfiguration().withConnectionConfiguration(configuration));
    }

    public static NingResponseResolver newInstance() {
        return NingResponseResolver.newInstance(new ConnectionConfiguration());
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        Future<Response> responseFuture = this.execute(request);
        return this.translate(responseFuture);
    }

    public void shutdown() {
        this.client.close();
    }

    private HTTPResponse translate(Future<Response> responseFuture) throws IOException {
        try {
            Response response = responseFuture.get();
            StatusLine line = new StatusLine(Status.valueOf((int)response.getStatusCode()), response.getStatusText());
            FluentCaseInsensitiveStringsMap headers = response.getHeaders();
            Optional<InputStream> stream = Optional.ofNullable(response.getResponseBodyAsStream());
            return ResponseCreator.createResponse((StatusLine)line, (Headers)new Headers((Map)headers), stream);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new HTTPException(e.getCause());
        }
        throw new HTTPException("Not possible to get response");
    }

    private Future<Response> execute(HTTPRequest request) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.builder(request.getNormalizedURI(), request.getMethod());
        if (request.getMethod().canHavePayload()) {
            request.getPayload().ifPresent(p -> {
                if (this.getConfiguration().isUseChunked()) {
                    builder.setBody((BodyGenerator)new InputStreamBodyGenerator(p.getInputStream()));
                } else {
                    builder.setBody(p.getInputStream());
                }
            });
        }
        for (Header header : request.getAllHeaders()) {
            builder.addHeader(header.getName(), header.getValue());
        }
        return builder.execute();
    }

    private AsyncHttpClient.BoundRequestBuilder builder(URI uri, HTTPMethod method) {
        if (HTTPMethod.DELETE.equals((Object)method)) {
            return this.client.prepareDelete(uri.toString());
        }
        if (HTTPMethod.GET.equals((Object)method)) {
            return this.client.prepareGet(uri.toString());
        }
        if (HTTPMethod.HEAD.equals((Object)method)) {
            return this.client.prepareHead(uri.toString());
        }
        if (HTTPMethod.OPTIONS.equals((Object)method)) {
            return this.client.prepareOptions(uri.toString());
        }
        if (HTTPMethod.POST.equals((Object)method)) {
            return this.client.preparePost(uri.toString());
        }
        if (HTTPMethod.PUT.equals((Object)method)) {
            return this.client.preparePut(uri.toString());
        }
        throw new IllegalArgumentException("Unable to create request for method " + method);
    }
}

