/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver.ning;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.FluentCaseInsensitiveStringsMap;
import com.ning.http.client.Response;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.codehaus.httpcache4j.HTTPException;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.mutable.MutableHeaders;
import org.codehaus.httpcache4j.payload.InputStreamPayload;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.resolver.AbstractResponseResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NingResponseResolver
extends AbstractResponseResolver {
    private final AsyncHttpClient client = new AsyncHttpClient();

    public NingResponseResolver(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        super(proxyAuthenticator, authenticator);
    }

    protected HTTPResponse resolveImpl(HTTPRequest request) throws IOException {
        Future<Response> responseFuture = this.execute(request);
        return this.translate(responseFuture);
    }

    public void shutdown() {
        this.client.close();
    }

    private HTTPResponse translate(Future<Response> responseFuture) throws IOException {
        try {
            Response response = responseFuture.get();
            StatusLine line = new StatusLine(Status.valueOf((int)response.getStatusCode()), response.getStatusText());
            FluentCaseInsensitiveStringsMap headers = response.getHeaders();
            MutableHeaders convertedHeaders = new MutableHeaders();
            for (Map.Entry entry : headers) {
                String key = (String)entry.getKey();
                List values = (List)entry.getValue();
                convertedHeaders.add((Iterable)Lists.transform((List)values, this.stringToHeader(key)));
            }
            InputStream stream = response.getResponseBodyAsStream();
            String contentType = response.getContentType();
            return new HTTPResponse((Payload)new InputStreamPayload(stream, contentType != null ? MIMEType.valueOf((String)contentType) : null), line, convertedHeaders.toHeaders());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            throw new HTTPException(e.getCause());
        }
        throw new HTTPException("Not possible to get response");
    }

    private Future<Response> execute(HTTPRequest request) throws IOException {
        AsyncHttpClient.BoundRequestBuilder builder = this.builder(request.getRequestURI(), request.getMethod());
        if (request.getMethod().canHavePayload() && request.hasPayload()) {
            builder.setBody(request.getPayload().getInputStream());
        }
        for (Header header : request.getAllHeaders()) {
            builder.addHeader(header.getName(), header.getValue());
        }
        return builder.execute();
    }

    private AsyncHttpClient.BoundRequestBuilder builder(URI uri, HTTPMethod method) {
        if (HTTPMethod.DELETE.equals((Object)method)) {
            return this.client.prepareDelete(uri.toString());
        }
        if (HTTPMethod.GET.equals((Object)method)) {
            return this.client.prepareGet(uri.toString());
        }
        if (HTTPMethod.HEAD.equals((Object)method)) {
            return this.client.prepareHead(uri.toString());
        }
        if (HTTPMethod.OPTIONS.equals((Object)method)) {
            return this.client.prepareOptions(uri.toString());
        }
        if (HTTPMethod.POST.equals((Object)method)) {
            return this.client.preparePost(uri.toString());
        }
        if (HTTPMethod.PUT.equals((Object)method)) {
            return this.client.preparePut(uri.toString());
        }
        throw new IllegalArgumentException("Unable to create request for method " + method);
    }

    private Function<String, Header> stringToHeader(final String key) {
        return new Function<String, Header>(){

            public Header apply(String from) {
                return new Header(key, from);
            }
        };
    }
}

