/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import java.util.Properties;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.cache.Vary;
import org.codehaus.httpcache4j.uri.URIBuilder;

public class Key
implements Serializable {
    private static final long serialVersionUID = 5827064595759738979L;
    private URI uri;
    private Vary vary;

    public static Key create(URI uri, Vary vary) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI may not be null");
        Preconditions.checkNotNull((Object)vary, (Object)"vary may not be null");
        return new Key(URIBuilder.fromURI((URI)uri).toNormalizedURI(), vary);
    }

    public static Key create(HTTPRequest request, HTTPResponse response) {
        URI uri = request.getNormalizedURI();
        return new Key(uri, Key.determineVariation(response.getHeaders(), request.getAllHeaders()));
    }

    private static Vary determineVariation(Headers responseHeaders, Headers requestHeaders) {
        String varyHeader = responseHeaders.getFirstHeaderValue("Vary");
        HashMap<String, String> resolvedVaryHeaders = new HashMap<String, String>();
        if (varyHeader != null) {
            String[] varies;
            for (String vary : varies = varyHeader.split(",")) {
                String value = requestHeaders.getFirstHeaderValue(vary);
                if (value == null) continue;
                resolvedVaryHeaders.put(vary, value);
            }
        }
        return new Vary(resolvedVaryHeaders);
    }

    Key(URI uri, Vary vary) {
        Preconditions.checkNotNull((Object)uri, (Object)"URI may not be null");
        Preconditions.checkNotNull((Object)vary, (Object)"Vary may not be null");
        this.uri = uri;
        this.vary = vary;
    }

    public URI getURI() {
        return this.uri;
    }

    public Vary getVary() {
        return this.vary;
    }

    public String toString() {
        return this.toProperties().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.uri != null ? !this.uri.equals(key.uri) : key.uri != null) {
            return false;
        }
        return !(this.vary != null ? !this.vary.equals(key.vary) : key.vary != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.vary != null ? this.vary.hashCode() : 0);
        return result;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.toProperties());
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Properties properties = (Properties)in.readObject();
        Key key = Key.parse(properties);
        this.uri = key.getURI();
        this.vary = key.getVary();
    }

    public static Key parse(Properties properties) {
        URI uri = null;
        Vary vary = null;
        if (properties.containsKey("uri")) {
            uri = URIBuilder.fromURI((URI)URI.create(properties.getProperty("uri"))).toNormalizedURI();
        }
        if (properties.containsKey("vary")) {
            vary = Vary.parse(properties.getProperty("vary"));
        }
        return new Key(uri, vary);
    }

    public Properties toProperties() {
        Properties object = new Properties();
        object.put("uri", this.uri.toString());
        object.put("vary", this.vary.toString());
        return object;
    }
}

