/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.text.Collator;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.util.ToJSON;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.type.TypeFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vary
implements ToJSON {
    private final Map<String, String> varyHeaders;

    public Vary() {
        this(Collections.emptyMap());
    }

    public Vary(Map<String, String> headers) {
        Validate.notNull(headers, (String)"Headers may not be null");
        TreeMap h = Maps.newTreeMap((Comparator)new VaryComparator());
        h.putAll(headers);
        this.varyHeaders = Collections.unmodifiableMap(h);
    }

    public Vary(Headers headers) {
        TreeMap h = Maps.newTreeMap((Comparator)new VaryComparator());
        for (Header header : headers) {
            h.put(header.getName(), header.getValue());
        }
        this.varyHeaders = Collections.unmodifiableMap(h);
    }

    public int size() {
        return this.varyHeaders.size();
    }

    public boolean isEmpty() {
        return this.varyHeaders.isEmpty();
    }

    public boolean matches(HTTPRequest request) {
        for (Map.Entry<String, String> varyEntry : this.varyHeaders.entrySet()) {
            Headers headers = request.getAllHeaders();
            List requestHeaderValue = headers.getHeaders(varyEntry.getKey());
            boolean valid = requestHeaderValue.isEmpty() ? varyEntry.getValue() == null : headers.getFirstHeader(varyEntry.getKey()).getValue().equals(varyEntry.getValue());
            if (valid) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Map.Entry<String, String> entry : this.varyHeaders.entrySet()) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(entry.getKey()).append(": ").append(entry);
        }
        return builder.toString();
    }

    public Map<String, String> getVaryHeaders() {
        return this.varyHeaders;
    }

    public static Vary fromJSON(String value) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            Map map = (Map)mapper.readValue(value, TypeFactory.mapType(LinkedHashMap.class, String.class, String.class));
            return new Vary(map);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public String toJSON() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString(this.varyHeaders);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vary vary = (Vary)o;
        return !(this.varyHeaders != null ? !((Object)this.varyHeaders).equals(vary.varyHeaders) : vary.varyHeaders != null);
    }

    public int hashCode() {
        return ((Object)this.varyHeaders).hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class VaryComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 7826440288680033131L;
        private transient Collator collator = this.getCollator();

        private Collator getCollator() {
            this.collator = Collator.getInstance(Locale.UK);
            return this.collator;
        }

        @Override
        public int compare(String one, String two) {
            return this.getCollator().compare(one, two);
        }

        private Object readResolve() {
            this.collator = this.getCollator();
            return this;
        }
    }
}

