/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.cache.Vary;

public class Key
implements Serializable {
    private static final long serialVersionUID = 5827064595759738979L;
    private URI uri;
    private Vary vary;

    public static Key create(URI uri, Vary vary) {
        Validate.notNull((Object)uri, (String)"URI may not be null");
        Validate.notNull((Object)vary, (String)"vary may not be null");
        return new Key(uri, vary);
    }

    public static Key create(HTTPRequest request, HTTPResponse response) {
        URI uri = request.getRequestURI();
        return new Key(uri, Key.determineVariation(request.getAllHeaders(), response.getHeaders()));
    }

    private static Vary determineVariation(Headers responseHeaders, Headers requestHeaders) {
        String varyHeader = responseHeaders.getFirstHeaderValue("Vary");
        HashMap<String, String> resolvedVaryHeaders = new HashMap<String, String>();
        if (varyHeader != null) {
            String[] varies;
            String[] arr$ = varies = varyHeader.split(",");
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String vary;
                String value = requestHeaders.getFirstHeaderValue(vary = arr$[i$]);
                resolvedVaryHeaders.put(vary, value == null ? null : value);
            }
        }
        return new Vary(resolvedVaryHeaders);
    }

    Key(URI uri, Vary vary) {
        Validate.notNull((Object)uri, (String)"URI may not be null");
        Validate.notNull((Object)vary, (String)"Vary may not be null");
        this.uri = uri;
        this.vary = vary;
    }

    public URI getURI() {
        return this.uri;
    }

    public Vary getVary() {
        return this.vary;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("URI: ").append(this.uri).append("\n");
        sb.append("VARY: ").append(this.vary).append("\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Key key = (Key)o;
        if (this.uri != null ? !this.uri.equals(key.uri) : key.uri != null) {
            return false;
        }
        return !(this.vary != null ? !this.vary.equals(key.vary) : key.vary != null);
    }

    public int hashCode() {
        int result = this.uri != null ? this.uri.hashCode() : 0;
        result = 31 * result + (this.vary != null ? this.vary.hashCode() : 0);
        return result;
    }
}

