/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.cache;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.HTTPRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Vary
implements Serializable {
    private final Map<String, String> varyHeaders = new HashMap<String, String>();

    public Vary(Map<String, String> headers) {
        Validate.notNull(headers);
        this.varyHeaders.putAll(headers);
    }

    public List<String> getVaryHeaderNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.varyHeaders.keySet()));
    }

    public boolean matches(HTTPRequest request) {
        for (Map.Entry<String, String> varyEntry : this.varyHeaders.entrySet()) {
            List requestHeaderValue = request.getHeaders().getHeaders(varyEntry.getKey());
            boolean valid = requestHeaderValue == null ? varyEntry.getValue() == null : request.getHeaders().getFirstHeader(varyEntry.getKey()).getValue().equals(varyEntry.getValue());
            if (valid) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vary vary = (Vary)o;
        return !(this.varyHeaders != null ? !((Object)this.varyHeaders).equals(vary.varyHeaders) : vary.varyHeaders != null);
    }

    public int hashCode() {
        return this.varyHeaders != null ? ((Object)this.varyHeaders).hashCode() : 0;
    }
}

