/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.uri.URIBuilder;

public final class HTTPRequest {
    private final URI requestURI;
    private final HTTPMethod method;
    private final Headers headers;
    private final Optional<Challenge> challenge;
    private final Optional<Payload> payload;
    private final URI normalizedURI;

    public HTTPRequest(URI requestURI, HTTPMethod method, Headers headers, Optional<Challenge> challenge, Optional<Payload> payload) {
        this.requestURI = Objects.requireNonNull(requestURI, "You MUST have a URI");
        this.normalizedURI = URIBuilder.fromURI((URI)requestURI).toNormalizedURI();
        this.method = method == null ? HTTPMethod.GET : method;
        this.headers = headers == null ? new Headers() : headers;
        this.challenge = Objects.requireNonNull(challenge, "Challenge may not be null");
        this.payload = Objects.requireNonNull(payload, "Payload may not be null");
    }

    public HTTPRequest copy() {
        return new HTTPRequest(this.getRequestURI(), this.getMethod(), this.getHeaders(), this.getChallenge(), this.getPayload());
    }

    public HTTPRequest(URI requestURI) {
        this(requestURI, HTTPMethod.GET);
    }

    public HTTPRequest(String requestURI) {
        this(URI.create(requestURI), HTTPMethod.GET);
    }

    public HTTPRequest(String requestURI, HTTPMethod method) {
        this(URI.create(requestURI), method);
    }

    public HTTPRequest(URI requestURI, HTTPMethod method) {
        this(requestURI, method, new Headers(), Optional.empty(), Optional.empty());
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public URI getNormalizedURI() {
        return this.normalizedURI;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Headers getAllHeaders() {
        Headers requestHeaders = this.getHeaders();
        requestHeaders = this.hasPayload() ? requestHeaders.withContentType(this.getPayload().get().getMimeType()) : requestHeaders;
        return requestHeaders;
    }

    public HTTPRequest addHeader(Header header) {
        Headers headers = this.headers.add(header);
        return new HTTPRequest(this.requestURI, this.method, headers, this.challenge, this.payload);
    }

    public HTTPRequest addHeader(String name, String value) {
        return this.addHeader(new Header(name, value));
    }

    public HTTPRequest setHeader(String name, String value) {
        return this.headers(this.headers.set(name, value));
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    @Deprecated
    public HTTPRequest method(HTTPMethod method) {
        return this.withMethod(method);
    }

    public HTTPRequest withMethod(HTTPMethod method) {
        Objects.requireNonNull(method, "You may not set null method");
        if (method == this.method) {
            return this;
        }
        return new HTTPRequest(this.requestURI, method, this.headers, this.challenge, this.payload);
    }

    public Optional<Challenge> getChallenge() {
        return this.challenge;
    }

    @Deprecated
    public HTTPRequest challenge(Challenge challenge) {
        return this.withChallenge(challenge);
    }

    public HTTPRequest withChallenge(Challenge challenge) {
        return new HTTPRequest(this.requestURI, this.method, this.headers, Optional.ofNullable(challenge), this.payload);
    }

    public Optional<Payload> getPayload() {
        return this.payload;
    }

    @Deprecated
    public HTTPRequest payload(Payload payload) {
        return this.withPayload(payload);
    }

    public HTTPRequest withPayload(Payload payload) {
        if (!this.method.canHavePayload()) {
            throw new IllegalStateException(String.format("Unable to add payload to a %s request", this.method));
        }
        return new HTTPRequest(this.requestURI, this.method, this.headers, this.challenge, Optional.ofNullable(payload));
    }

    public HTTPRequest headers(Headers headers) {
        Objects.requireNonNull(headers, "You may not set null headers");
        return new HTTPRequest(this.requestURI, this.method, headers, this.challenge, this.payload);
    }

    public boolean hasPayload() {
        return this.payload.isPresent();
    }

    public Optional<CacheControl> getCacheControl() {
        return this.headers.getCacheControl();
    }

    @Deprecated
    public HTTPRequest cacheControl(CacheControl cc) {
        return this.withCacheControl(cc);
    }

    public HTTPRequest withCacheControl(CacheControl cc) {
        return this.addHeader(cc.toHeader());
    }

    public HTTPRequest addIfNoneMatch(Tag tag) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().addIfNoneMatch(tag)));
    }

    public HTTPRequest addIfMatch(Tag tag) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().addIfMatch(tag)));
    }

    public HTTPRequest withIfUnModifiedSince(LocalDateTime dt) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().ifUnModifiedSince(dt)));
    }

    public HTTPRequest withIfModifiedSince(LocalDateTime dt) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().ifModifiedSince(dt)));
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.requestURI.getScheme());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPRequest that = (HTTPRequest)o;
        if (this.challenge != null ? !this.challenge.equals(that.challenge) : that.challenge != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.normalizedURI != null ? !this.normalizedURI.equals(that.normalizedURI) : that.normalizedURI != null) {
            return false;
        }
        return !(this.payload == null ? that.payload != null : !this.payload.equals(that.payload));
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.challenge != null ? this.challenge.hashCode() : 0);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.normalizedURI != null ? this.normalizedURI.hashCode() : 0);
        return result;
    }
}

