/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.uri.QueryParam;
import org.codehaus.httpcache4j.uri.QueryParams;

public final class FormDataPayload
implements Payload {
    private final MIMEType mimeType = new MIMEType("application/x-www-form-urlencoded");
    private final String value;

    public FormDataPayload(Map<String, List<String>> parameters) {
        this(new QueryParams(parameters).toQuery(false));
    }

    public FormDataPayload(List<QueryParam> parameters) {
        this(new QueryParams(parameters).toQuery(false));
    }

    public FormDataPayload(String formatted) {
        this.value = Objects.requireNonNull(formatted, "form data may not be null");
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.value.getBytes(StandardCharsets.UTF_8));
    }

    @Deprecated
    public String getValues() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public long length() {
        return this.value.length();
    }
}

