/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import java.net.URI;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Conditionals;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.NameValue;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.mutable.MutableHeaders;
import org.codehaus.httpcache4j.preference.Preference;
import org.codehaus.httpcache4j.util.CaseInsensitiveKey;
import org.codehaus.httpcache4j.util.NumberUtils;
import org.codehaus.httpcache4j.util.Streamable;

public final class Headers
implements Streamable<Header> {
    private final HeaderHashMap headers = new HeaderHashMap();

    public Headers() {
    }

    public Headers(Headers headers) {
        this(headers.copyMap());
    }

    public Headers(Map<String, List<String>> headers) {
        this(new HeaderHashMap(headers));
    }

    private Headers(HeaderHashMap headers) {
        this.headers.putAll(Objects.requireNonNull(headers, "The header map may not be null"));
    }

    public List<Header> getHeaders(String name) {
        return this.headers.getAsHeaders(name);
    }

    public List<Directives> getDirectives(String name) {
        return this.getHeaders(name).stream().map(Header::getDirectives).collect(Collectors.toList());
    }

    public Optional<Header> getFirstHeader(String headerKey) {
        List<Header> headerList = this.getHeaders(headerKey);
        return headerList.stream().findFirst();
    }

    public Optional<String> getFirstHeaderValue(String headerKey) {
        Optional<Header> header = this.getFirstHeader(headerKey);
        return header.map(NameValue::getValue);
    }

    public Optional<Directives> getFirstHeaderValueAsDirectives(String headerKey) {
        Optional<Header> header = this.getFirstHeader(headerKey);
        return header.map(Header::getDirectives);
    }

    public Headers add(Header header) {
        return this.add(Collections.singletonList(header));
    }

    public Headers add(String key, String value) {
        return this.add(new Header(key, value));
    }

    public Headers add(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        for (Header header : headers) {
            String value;
            ArrayList<String> list = new ArrayList<String>(map.get(header.getName()));
            if (!list.contains(value = this.normalizeValue(header.getName(), header.getValue()))) {
                list.add(value);
            }
            map.put(header.getName(), (List<String>)list);
        }
        return new Headers(map);
    }

    public Headers add(String name, Iterable<String> values) {
        ArrayList<Header> list = new ArrayList<Header>();
        for (String value : values) {
            list.add(new Header(name, value));
        }
        return this.add(list);
    }

    public Headers set(Header header) {
        HeaderHashMap headers = this.copyMap();
        String normalized = this.normalizeValue(header.getName(), header.getValue());
        headers.put(header.getName(), (List<String>)new ArrayList<String>(Arrays.asList(normalized)));
        return new Headers(headers);
    }

    public Headers set(String name, String value) {
        return this.set(new Header(name, value));
    }

    public Headers set(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        Headers copy = new Headers().add(headers);
        Set<String> keys = copy.keySet();
        for (String key : keys) {
            map.put(key, copy.headers.get(key));
        }
        return new Headers(map);
    }

    public boolean contains(Header header) {
        List<Header> values = this.getHeaders(header.getName());
        return values.contains(header);
    }

    public boolean contains(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    @Deprecated
    public boolean hasHeader(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    public Headers remove(String name) {
        HeaderHashMap heads = this.copyMap();
        heads.remove(name);
        return new Headers(heads);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.headerIterator();
    }

    public Set<String> keySet() {
        return this.headers.keys();
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public Headers asCacheable() {
        return HeaderUtils.cleanForCaching(this);
    }

    public boolean isCachable() {
        return HeaderUtils.hasCacheableHeaders(this);
    }

    public List<Preference> getAcceptLanguage() {
        return Preference.parse(this.getFirstHeader("Accept-Language"));
    }

    public Headers withAcceptLanguage(List<Preference> acceptLanguage) {
        return this.set(Preference.toHeader("Accept-Language", acceptLanguage));
    }

    public List<Preference> getAcceptCharset() {
        return Preference.parse(this.getFirstHeader("Accept-Charset"));
    }

    public Headers withAcceptCharset(List<Preference> charsets) {
        return this.set(Preference.toHeader("Accept-Charset", charsets));
    }

    public List<Preference> getAccept() {
        return Preference.parse(this.getFirstHeader("Accept"));
    }

    public Headers withAccept(List<Preference> charsets) {
        return this.set(Preference.toHeader("Accept", charsets));
    }

    public Headers addAccept(Preference ... accept) {
        List<Preference> preferences = Arrays.asList(accept);
        return this.add(Preference.toHeader("Accept", preferences));
    }

    public Headers addAccept(MIMEType ... accept) {
        List<Preference> preferences = Arrays.asList(accept).stream().map(MIMEType::toString).map(Preference::new).collect(Collectors.toList());
        return this.add(Preference.toHeader("Accept", preferences));
    }

    public Headers addAcceptLanguage(Locale ... accept) {
        Function<Locale, String> f = a -> a.getLanguage() + "-" + a.getCountry().toLowerCase(Locale.ENGLISH);
        List<Preference> preferences = Arrays.asList(accept).stream().map(f).map(Preference::new).collect(Collectors.toList());
        return this.add(Preference.toHeader("Accept-Language", preferences));
    }

    public Headers addAcceptLanguage(Preference ... accept) {
        List<Preference> preferences = Arrays.asList(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences));
    }

    public Headers addAcceptCharset(Preference ... accept) {
        List<Preference> preferences = Arrays.asList(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences));
    }

    public Set<HTTPMethod> getAllow() {
        Optional<Header> header = this.getFirstHeader("Allow");
        if (header.isPresent()) {
            return header.get().getDirectives().stream().map(d -> HTTPMethod.valueOf(d.getName().toUpperCase(Locale.ENGLISH))).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public Headers withAllow(Set<HTTPMethod> allow) {
        if (!allow.isEmpty()) {
            String value = allow.stream().map(HTTPMethod::getMethod).collect(Collectors.joining(","));
            return this.set("Allow", value);
        }
        return this.remove("Allow");
    }

    public Optional<CacheControl> getCacheControl() {
        return this.getFirstHeader("Cache-Control").map(CacheControl::new);
    }

    public Headers withCacheControl(CacheControl cc) {
        return this.set(cc.toHeader());
    }

    public Optional<LocalDateTime> getDate() {
        return this.getFirstHeader("Date").flatMap(HeaderUtils::fromHttpDate);
    }

    public Headers withDate(LocalDateTime dt) {
        return this.set(HeaderUtils.toHttpDate("Date", dt));
    }

    public Optional<MIMEType> getContentType() {
        Optional<String> ct = this.getFirstHeaderValue("Content-Type");
        return ct.map(MIMEType::valueOf);
    }

    public Headers withContentType(MIMEType ct) {
        return this.set("Content-Type", ct.toString());
    }

    public Optional<LocalDateTime> getExpires() {
        return this.getFirstHeader("Expires").flatMap(HeaderUtils::fromHttpDate);
    }

    public Headers withExpires(LocalDateTime expires) {
        return this.set(HeaderUtils.toHttpDate("Expires", expires));
    }

    public Optional<LocalDateTime> getLastModified() {
        return this.getFirstHeader("Last-Modified").flatMap(HeaderUtils::fromHttpDate);
    }

    public Headers withLastModified(LocalDateTime lm) {
        return this.set(HeaderUtils.toHttpDate("Last-Modified", lm));
    }

    public Conditionals getConditionals() {
        return Conditionals.valueOf(this);
    }

    public Headers withConditionals(Conditionals conditionals) {
        return this.add(conditionals.toHeaders());
    }

    public Optional<Tag> getETag() {
        Optional<String> tag = this.getFirstHeaderValue("ETag");
        return tag.flatMap(Tag::parse);
    }

    public Headers withETag(Tag tag) {
        return this.set("ETag", tag.format());
    }

    public Optional<URI> getLocation() {
        return this.getFirstHeaderValue("Location").map(URI::create);
    }

    public Headers withLocation(URI href) {
        return this.set("Location", href.toString());
    }

    public Optional<Long> getContentLength() {
        return this.getFirstHeaderValue("Content-Length").flatMap(NumberUtils::optToLong);
    }

    public Headers withContentLength(long length) {
        return this.set("Content-Length", String.valueOf(length));
    }

    public Optional<URI> getContentLocation() {
        return this.getFirstHeaderValue("Content-Location").map(URI::create);
    }

    public Headers withContentLocation(URI href) {
        return this.set("Content-Location", href.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers1 = (Headers)o;
        return this.headers.equals(headers1.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header header : this) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(header);
        }
        return builder.toString();
    }

    private HeaderHashMap copyMap() {
        return new HeaderHashMap(this.headers);
    }

    private String normalizeValue(String name, String value) {
        if (name.toLowerCase().startsWith("accept")) {
            List<Preference> parse = Preference.parse(new Header(name, value));
            value = Preference.toHeader(name, parse).getValue();
        }
        return value;
    }

    public static Headers parse(String input) {
        String[] fields;
        if (input == null || input.trim().isEmpty()) {
            return new Headers();
        }
        MutableHeaders headers = new MutableHeaders();
        for (String field : fields = input.split("\r\n")) {
            headers.add(Header.valueOf(field.trim()));
        }
        return headers.toHeaders();
    }

    private static class HeaderHashMap
    extends LinkedHashMap<CaseInsensitiveKey, List<String>> {
        private static final long serialVersionUID = 2714358409043444835L;

        public HeaderHashMap() {
        }

        public HeaderHashMap(HeaderHashMap headerHashMap) {
            super(headerHashMap);
        }

        public HeaderHashMap(Map<String, List<String>> headerHashMap) {
            super(headerHashMap.entrySet().stream().map(k -> new AbstractMap.SimpleImmutableEntry(new CaseInsensitiveKey((String)k.getKey()), k.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        public List<String> get(String key) {
            return this.get(new CaseInsensitiveKey(key));
        }

        public Set<String> keys() {
            HashSet<String> strings = new HashSet<String>();
            for (CaseInsensitiveKey name : super.keySet()) {
                strings.add(name.getDelegate());
            }
            return strings;
        }

        @Override
        public List<String> get(Object key) {
            List<String> value = (List<String>)super.get(key);
            return value != null ? value : Collections.emptyList();
        }

        List<Header> getAsHeaders(String key) {
            CaseInsensitiveKey name = new CaseInsensitiveKey(key);
            List headers = this.get(name).stream().map(v -> new Header(name.getDelegate(), (String)v)).collect(Collectors.toList());
            return Collections.unmodifiableList(headers);
        }

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(new CaseInsensitiveKey(key), value);
        }

        public List<String> remove(String key) {
            return (List)this.remove(new CaseInsensitiveKey(key));
        }

        Iterator<Header> headerIterator() {
            List headers = this.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(v -> new Header(((CaseInsensitiveKey)e.getKey()).getDelegate(), (String)v))).collect(Collectors.toList());
            return headers.iterator();
        }
    }
}

