/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Conditionals;
import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.mutable.MutableHeaders;
import org.codehaus.httpcache4j.preference.Charset;
import org.codehaus.httpcache4j.preference.Preference;
import org.codehaus.httpcache4j.util.CaseInsensitiveKey;
import org.joda.time.DateTime;

public final class Headers
implements Iterable<Header> {
    private final HeaderHashMap headers = new HeaderHashMap();

    public Headers() {
    }

    public Headers(Headers headers) {
        this(headers.copyMap());
    }

    private Headers(HeaderHashMap headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"The header map may not be null");
        this.headers.putAll(headers);
    }

    public List<Header> getHeaders(String name) {
        return this.headers.getAsHeaders(name);
    }

    public List<Directives> getDirectives(String name) {
        return Lists.transform(this.getHeaders(name), (Function)new Function<Header, Directives>(){

            public Directives apply(Header input) {
                return input.getDirectives();
            }
        });
    }

    public Header getFirstHeader(String headerKey) {
        List<Header> headerList = this.getHeaders(headerKey);
        if (!headerList.isEmpty()) {
            return headerList.get(0);
        }
        return null;
    }

    public String getFirstHeaderValue(String headerKey) {
        Header header = this.getFirstHeader(headerKey);
        if (header != null) {
            return header.getValue();
        }
        return null;
    }

    public Directives getFirstHeaderValueAsDirectives(String headerKey) {
        Header header = this.getFirstHeader(headerKey);
        if (header != null) {
            return header.getDirectives();
        }
        return null;
    }

    public Headers add(Header header) {
        return this.add(Collections.singletonList(header));
    }

    public Headers add(String key, String value) {
        return this.add(new Header(key, value));
    }

    public Headers add(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        for (Header header : headers) {
            String value;
            ArrayList<String> list = new ArrayList<String>(map.get(header.getName()));
            if (!list.contains(value = this.normalizeValue(header.getName(), header.getValue()))) {
                list.add(value);
            }
            map.put(header.getName(), (List<String>)list);
        }
        return new Headers(map);
    }

    public Headers add(String name, Iterable<String> values) {
        ArrayList<Header> list = new ArrayList<Header>();
        for (String value : values) {
            list.add(new Header(name, value));
        }
        return this.add(list);
    }

    public Headers set(Header header) {
        HeaderHashMap headers = this.copyMap();
        String normalized = this.normalizeValue(header.getName(), header.getValue());
        headers.put(header.getName(), Lists.newArrayList((Object[])new String[]{normalized}));
        return new Headers(headers);
    }

    public Headers set(String name, String value) {
        return this.set(new Header(name, value));
    }

    public Headers set(Iterable<Header> headers) {
        HeaderHashMap map = this.copyMap();
        Headers copy = new Headers().add(headers);
        Set<String> keys = copy.keySet();
        for (String key : keys) {
            map.put(key, copy.headers.get(key));
        }
        return new Headers(map);
    }

    public boolean contains(Header header) {
        List<Header> values = this.getHeaders(header.getName());
        return values.contains(header);
    }

    public boolean contains(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    @Deprecated
    public boolean hasHeader(String headerName) {
        return !this.headers.get(headerName).isEmpty();
    }

    public Headers remove(String name) {
        HeaderHashMap heads = this.copyMap();
        heads.remove(name);
        return new Headers(heads);
    }

    @Override
    public Iterator<Header> iterator() {
        return this.headers.headerIterator();
    }

    public Set<String> keySet() {
        return this.headers.keys();
    }

    public int size() {
        return this.headers.size();
    }

    public boolean isEmpty() {
        return this.headers.isEmpty();
    }

    public Headers asCacheable() {
        return HeaderUtils.cleanForCaching(this);
    }

    public boolean isCachable() {
        return HeaderUtils.hasCacheableHeaders(this);
    }

    public List<Preference<Locale>> getAcceptLanguage() {
        return Preference.parse(this.getFirstHeader("Accept-Language"), Preference.LocaleParse);
    }

    public Headers withAcceptLanguage(List<Preference<Locale>> acceptLanguage) {
        return this.set(Preference.toHeader("Accept-Language", acceptLanguage, Preference.LocaleToString));
    }

    public List<Preference<Charset>> getAcceptCharset() {
        return Preference.parse(this.getFirstHeader("Accept-Charset"), Preference.CharsetParse);
    }

    public Headers withAcceptCharset(List<Preference<Charset>> charsets) {
        return this.set(Preference.toHeader("Accept-Charset", charsets, Preference.CharsetToString));
    }

    public List<Preference<MIMEType>> getAccept() {
        return Preference.parse(this.getFirstHeader("Accept"), Preference.MIMEParse);
    }

    /*
     * Exception decompiling
     */
    public Headers withAccept(List<Preference<MIMEType>> charsets) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Headers addAccept(Preference<MIMEType> ... accept) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public Headers addAccept(MIMEType ... accept) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.AbstractExpressionRewriter.rewriteExpression(AbstractExpressionRewriter.java:14)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:75)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public Headers addAcceptLanguage(Locale ... accept) {
        List<Preference<Locale>> preferences = Preference.wrap(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences, Preference.LocaleToString));
    }

    public Headers addAcceptLanguage(Preference<Locale> ... accept) {
        List<Preference<Locale>> preferences = Arrays.asList(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences, Preference.LocaleToString));
    }

    public Headers addAcceptCharset(Charset ... accept) {
        List<Preference<Charset>> preferences = Preference.wrap(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences, Preference.CharsetToString));
    }

    public Headers addAcceptCharset(Preference<Charset> ... accept) {
        List<Preference<Charset>> preferences = Arrays.asList(accept);
        return this.add(Preference.toHeader("Accept-Language", preferences, Preference.CharsetToString));
    }

    public Set<HTTPMethod> getAllow() {
        Header header = this.getFirstHeader("Allow");
        if (header != null) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (Directive directive : header.getDirectives()) {
                builder.add((Object)HTTPMethod.valueOf(directive.getName().toUpperCase(Locale.ENGLISH)));
            }
            return builder.build();
        }
        return Collections.emptySet();
    }

    public Headers withAllow(Set<HTTPMethod> allow) {
        if (!allow.isEmpty()) {
            String allowValue = Joiner.on((String)",").skipNulls().join(allow);
            return this.set("Allow", allowValue);
        }
        return this.remove("Allow");
    }

    public CacheControl getCacheControl() {
        return new CacheControl(this.getFirstHeader("Cache-Control"));
    }

    public Headers withCacheControl(CacheControl cc) {
        return this.set(cc.toHeader());
    }

    public DateTime getDate() {
        return HeaderUtils.fromHttpDate(this.getFirstHeader("Date"));
    }

    public Headers withDate(DateTime dt) {
        return this.set(HeaderUtils.toHttpDate("Date", dt));
    }

    public MIMEType getContentType() {
        String ct = this.getFirstHeaderValue("Content-Type");
        return ct == null ? null : MIMEType.valueOf(ct);
    }

    public Headers withContentType(MIMEType ct) {
        return this.set("Content-Type", ct.toString());
    }

    public DateTime getExpires() {
        return HeaderUtils.fromHttpDate(this.getFirstHeader("Expires"));
    }

    public Headers withExpires(DateTime expires) {
        return this.set(HeaderUtils.toHttpDate("Expires", expires));
    }

    public DateTime getLastModified() {
        return HeaderUtils.fromHttpDate(this.getFirstHeader("Last-Modified"));
    }

    public Headers withLastModified(DateTime lm) {
        return this.set(HeaderUtils.toHttpDate("Last-Modified", lm));
    }

    public Conditionals getConditionals() {
        return Conditionals.valueOf(this);
    }

    public Headers withConditionals(Conditionals conditionals) {
        return this.add(conditionals.toHeaders());
    }

    public Tag getETag() {
        Header tag = this.getFirstHeader("ETag");
        if (tag != null) {
            return Tag.parse(tag.getValue());
        }
        return null;
    }

    public Headers withETag(Tag tag) {
        return this.set("ETag", tag.format());
    }

    public URI getLocation() {
        String location = this.getFirstHeaderValue("Location");
        if (location != null) {
            return URI.create(location);
        }
        return null;
    }

    public Headers withLocation(URI href) {
        return this.set("Location", href.toString());
    }

    public URI getContentLocation() {
        String location = this.getFirstHeaderValue("Content-Location");
        if (location != null) {
            return URI.create(location);
        }
        return null;
    }

    public Headers withContentLocation(URI href) {
        return this.set("Content-Location", href.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Headers headers1 = (Headers)o;
        return this.headers.equals(headers1.headers);
    }

    public int hashCode() {
        return this.headers.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Header header : this) {
            if (builder.length() > 0) {
                builder.append("\r\n");
            }
            builder.append(header);
        }
        return builder.toString();
    }

    private HeaderHashMap copyMap() {
        return new HeaderHashMap(this.headers);
    }

    private String normalizeValue(String name, String value) {
        if (name.toLowerCase().startsWith("accept")) {
            List parse = Preference.parse(new Header(name, value), Functions.identity());
            value = Preference.toHeader(name, parse, Functions.identity()).getValue();
        }
        return value;
    }

    public static Headers parse(String input) {
        String[] fields;
        if (input == null || input.trim().isEmpty()) {
            return new Headers();
        }
        MutableHeaders headers = new MutableHeaders();
        for (String field : fields = input.split("\r\n")) {
            headers.add(Header.valueOf(field.trim()));
        }
        return headers.toHeaders();
    }

    private static class HeaderHashMap
    extends LinkedHashMap<CaseInsensitiveKey, List<String>> {
        private static final long serialVersionUID = 2714358409043444835L;
        private static final Function<Header, String> headerToString = new Function<Header, String>(){

            public String apply(Header from) {
                return from.getValue();
            }
        };

        public HeaderHashMap() {
        }

        public HeaderHashMap(HeaderHashMap headerHashMap) {
            super(headerHashMap);
        }

        public List<String> get(String key) {
            return this.get(new CaseInsensitiveKey(key));
        }

        public Set<String> keys() {
            HashSet<String> strings = new HashSet<String>();
            for (CaseInsensitiveKey name : super.keySet()) {
                strings.add(name.getDelegate());
            }
            return strings;
        }

        @Override
        public List<String> get(Object key) {
            List<String> value = (List<String>)super.get(key);
            return value != null ? value : Collections.emptyList();
        }

        List<Header> getAsHeaders(String key) {
            ArrayList headers = new ArrayList();
            CaseInsensitiveKey name = new CaseInsensitiveKey(key);
            headers.addAll(Lists.transform((List)this.get(name), this.nameToHeader(name)));
            return Collections.unmodifiableList(headers);
        }

        private Function<String, Header> nameToHeader(final CaseInsensitiveKey key) {
            return new Function<String, Header>(){

                public Header apply(String from) {
                    return new Header(key.getDelegate(), from);
                }
            };
        }

        @Override
        public List<String> put(String key, List<String> value) {
            return super.put(new CaseInsensitiveKey(key), value);
        }

        public List<String> remove(String key) {
            return (List)this.remove(new CaseInsensitiveKey(key));
        }

        Iterator<Header> headerIterator() {
            ArrayList headers = new ArrayList();
            for (Map.Entry entry : this.entrySet()) {
                headers.addAll(Lists.transform((List)((List)entry.getValue()), this.nameToHeader((CaseInsensitiveKey)entry.getKey())));
            }
            return headers.iterator();
        }
    }
}

