/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Preconditions;
import java.net.URI;
import org.codehaus.httpcache4j.CacheControl;
import org.codehaus.httpcache4j.Challenge;
import org.codehaus.httpcache4j.HTTPMethod;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.uri.URIBuilder;
import org.joda.time.DateTime;

public final class HTTPRequest {
    private final URI requestURI;
    private final HTTPMethod method;
    private final Headers headers;
    private final Challenge challenge;
    private final Payload payload;
    private final URI normalizedURI;

    public HTTPRequest(URI requestURI, HTTPMethod method, Headers headers, Challenge challenge, Payload payload) {
        this.requestURI = (URI)Preconditions.checkNotNull((Object)requestURI, (Object)"You MUST have a URI");
        this.normalizedURI = URIBuilder.fromURI((URI)requestURI).toNormalizedURI();
        this.method = method == null ? HTTPMethod.GET : method;
        this.headers = headers == null ? new Headers() : headers;
        this.challenge = challenge;
        this.payload = payload;
    }

    public HTTPRequest copy() {
        return new HTTPRequest(this.getRequestURI(), this.getMethod(), this.getHeaders(), this.getChallenge(), this.getPayload());
    }

    public HTTPRequest(URI requestURI) {
        this(requestURI, HTTPMethod.GET);
    }

    public HTTPRequest(String requestURI) {
        this(URI.create(requestURI), HTTPMethod.GET);
    }

    public HTTPRequest(String requestURI, HTTPMethod method) {
        this(URI.create(requestURI), method);
    }

    public HTTPRequest(URI requestURI, HTTPMethod method) {
        this(requestURI, method, new Headers(), null, null);
    }

    public URI getRequestURI() {
        return this.requestURI;
    }

    public URI getNormalizedURI() {
        return this.normalizedURI;
    }

    public Headers getHeaders() {
        return this.headers;
    }

    public Headers getAllHeaders() {
        Headers requestHeaders = this.getHeaders();
        if (this.hasPayload()) {
            requestHeaders = requestHeaders.set("Content-Type", this.getPayload().getMimeType().toString());
        }
        return requestHeaders;
    }

    public HTTPRequest addHeader(Header header) {
        Headers headers = this.headers.add(header);
        return new HTTPRequest(this.requestURI, this.method, headers, this.challenge, this.payload);
    }

    public HTTPRequest addHeader(String name, String value) {
        return this.addHeader(new Header(name, value));
    }

    public HTTPRequest setHeader(String name, String value) {
        return this.headers(this.headers.set(name, value));
    }

    public HTTPMethod getMethod() {
        return this.method;
    }

    public HTTPRequest method(HTTPMethod method) {
        Preconditions.checkNotNull((Object)method, (Object)"You may not set null method");
        if (method == this.method) {
            return this;
        }
        return new HTTPRequest(this.requestURI, method, this.headers, this.challenge, this.payload);
    }

    public Challenge getChallenge() {
        return this.challenge;
    }

    public HTTPRequest challenge(Challenge challenge) {
        return new HTTPRequest(this.requestURI, this.method, this.headers, challenge, this.payload);
    }

    public Payload getPayload() {
        return this.payload;
    }

    public HTTPRequest payload(Payload payload) {
        if (!this.method.canHavePayload()) {
            throw new IllegalStateException(String.format("Unable to add payload to a %s request", this.method));
        }
        return new HTTPRequest(this.requestURI, this.method, this.headers, this.challenge, payload);
    }

    public HTTPRequest headers(Headers headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"You may not set null headers");
        return new HTTPRequest(this.requestURI, this.method, headers, this.challenge, this.payload);
    }

    public boolean hasPayload() {
        return this.payload != null;
    }

    public CacheControl getCacheControl() {
        if (this.headers.contains("Cache-Control")) {
            return new CacheControl(this.headers.getFirstHeader("Cache-Control"));
        }
        return null;
    }

    public HTTPRequest cacheControl(CacheControl cc) {
        return this.addHeader(cc.toHeader());
    }

    public HTTPRequest addIfNoneMatch(Tag tag) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().addIfNoneMatch(tag)));
    }

    public HTTPRequest addIfMatch(Tag tag) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().addIfMatch(tag)));
    }

    public HTTPRequest withIfUnModifiedSince(DateTime dt) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().ifUnModifiedSince(dt)));
    }

    public HTTPRequest withIfModifiedSince(DateTime dt) {
        return this.headers(this.headers.withConditionals(this.headers.getConditionals().ifModifiedSince(dt)));
    }

    public boolean isSecure() {
        return "https".equalsIgnoreCase(this.requestURI.getScheme());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPRequest that = (HTTPRequest)o;
        if (this.challenge != null ? !this.challenge.equals(that.challenge) : that.challenge != null) {
            return false;
        }
        if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) {
            return false;
        }
        if (this.method != null ? !this.method.equals(that.method) : that.method != null) {
            return false;
        }
        if (this.normalizedURI != null ? !this.normalizedURI.equals(that.normalizedURI) : that.normalizedURI != null) {
            return false;
        }
        return !(this.payload == null ? that.payload != null : !this.payload.equals(that.payload));
    }

    public int hashCode() {
        int result = this.method != null ? this.method.hashCode() : 0;
        result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
        result = 31 * result + (this.challenge != null ? this.challenge.hashCode() : 0);
        result = 31 * result + (this.payload != null ? this.payload.hashCode() : 0);
        result = 31 * result + (this.normalizedURI != null ? this.normalizedURI.hashCode() : 0);
        return result;
    }
}

