/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

public final class Tag {
    public static final Tag ALL = Tag.parse("*");
    private boolean weak;
    private String opaqueTag;

    public static Tag parse(String httpTag) {
        Tag result = null;
        boolean weak = false;
        String internal = httpTag;
        if (internal.startsWith("W/")) {
            weak = true;
            internal = internal.substring(2);
        }
        if (internal.startsWith("\"") && internal.endsWith("\"")) {
            result = new Tag(internal.substring(1, internal.length() - 1), weak);
        } else if (internal.equals("*")) {
            result = new Tag("*", weak);
        }
        return result;
    }

    public Tag(String opaqueTag, boolean weak) {
        this.opaqueTag = opaqueTag;
        this.weak = weak;
    }

    public Tag(String opaqueTag) {
        this(opaqueTag, false);
    }

    public boolean equals(Object object) {
        return this.equals(object, true);
    }

    public boolean equals(Object object, boolean checkWeakness) {
        boolean result;
        boolean bl = result = object != null && object instanceof Tag;
        if (result) {
            Tag that = (Tag)object;
            if (checkWeakness) {
                boolean bl2 = result = that.isWeak() == this.isWeak();
            }
            if (result) {
                result = this.getName() == null ? that.getName() == null : this.getName().equals(that.getName());
            }
        }
        return result;
    }

    public String format() {
        if (this.getName().equals("*")) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isWeak()) {
            sb.append("W/");
        }
        return sb.append('\"').append(this.getName()).append('\"').toString();
    }

    public String getName() {
        return this.opaqueTag;
    }

    public String toString() {
        return "opaque tag: " + this.getName() + " is weak: " + this.isWeak();
    }

    public int hashCode() {
        return this.format().hashCode();
    }

    public boolean isWeak() {
        return this.weak;
    }
}

