/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.HeaderUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.Tag;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public final class Conditionals {
    private final List<Tag> match;
    private final List<Tag> noneMatch;
    private final DateTime modifiedSince;
    private final DateTime unModifiedSince;
    private static final String ERROR_MESSAGE = "The combination of %s and %s is undefined by the HTTP specification";
    public static Function<String, Tag> tagFunction = new Function<String, Tag>(){

        public Tag apply(String input) {
            return Tag.parse(input);
        }
    };

    public Conditionals() {
        this(Conditionals.empty(), Conditionals.empty(), null, null);
    }

    private static List<Tag> empty() {
        return Collections.emptyList();
    }

    public Conditionals(List<Tag> match, List<Tag> noneMatch, DateTime modifiedSince, DateTime unModifiedSince) {
        this.match = match;
        this.noneMatch = noneMatch;
        this.modifiedSince = modifiedSince;
        this.unModifiedSince = unModifiedSince;
    }

    public Conditionals addIfMatch(Tag tag) {
        Preconditions.checkArgument((this.modifiedSince == null ? 1 : 0) != 0, (Object)String.format(ERROR_MESSAGE, "If-Match", "If-Modified-Since"));
        Preconditions.checkArgument((boolean)this.noneMatch.isEmpty(), (Object)String.format(ERROR_MESSAGE, "If-Match", "If-None-Match"));
        ArrayList<Tag> match = new ArrayList<Tag>(this.match);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            match.clear();
        }
        if (!match.contains(Tag.ALL)) {
            if (!match.contains(tag)) {
                match.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Collections.unmodifiableList(match), Conditionals.empty(), null, this.unModifiedSince);
    }

    public Conditionals addIfNoneMatch(Tag tag) {
        Preconditions.checkArgument((this.unModifiedSince == null ? 1 : 0) != 0, (Object)String.format(ERROR_MESSAGE, "If-None-Match", "If-Unmodified-Since"));
        Preconditions.checkArgument((boolean)this.match.isEmpty(), (Object)String.format(ERROR_MESSAGE, "If-None-Match", "If-Match"));
        ArrayList<Tag> noneMatch = new ArrayList<Tag>(this.noneMatch);
        if (tag == null) {
            tag = Tag.ALL;
        }
        if (Tag.ALL.equals(tag)) {
            noneMatch.clear();
        }
        if (!noneMatch.contains(Tag.ALL)) {
            if (!noneMatch.contains(tag)) {
                noneMatch.add(tag);
            }
        } else {
            throw new IllegalArgumentException("Tag ALL already in the list");
        }
        return new Conditionals(Conditionals.empty(), Collections.unmodifiableList(noneMatch), this.modifiedSince, null);
    }

    public Conditionals ifModifiedSince(DateTime time) {
        Preconditions.checkArgument((boolean)this.match.isEmpty(), (Object)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Match"));
        Preconditions.checkArgument((this.unModifiedSince == null ? 1 : 0) != 0, (Object)String.format(ERROR_MESSAGE, "If-Modified-Since", "If-Unmodified-Since"));
        time = time.toDateTime(DateTimeZone.forID((String)"UTC"));
        time = time.withMillisOfSecond(0);
        return new Conditionals(Conditionals.empty(), this.noneMatch, time, null);
    }

    public Conditionals ifUnModifiedSince(DateTime time) {
        Preconditions.checkArgument((boolean)this.noneMatch.isEmpty(), (Object)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-None-Match"));
        Preconditions.checkArgument((this.modifiedSince == null ? 1 : 0) != 0, (Object)String.format(ERROR_MESSAGE, "If-Unmodified-Since", "If-Modified-Since"));
        time = time.toDateTime(DateTimeZone.forID((String)"UTC"));
        time = time.withMillisOfSecond(0);
        return new Conditionals(this.match, Conditionals.empty(), null, time);
    }

    public List<Tag> getMatch() {
        return Collections.unmodifiableList(this.match);
    }

    public List<Tag> getNoneMatch() {
        return Collections.unmodifiableList(this.noneMatch);
    }

    public DateTime getModifiedSince() {
        return this.modifiedSince;
    }

    public DateTime getUnModifiedSince() {
        return this.unModifiedSince;
    }

    public boolean isUnconditional() {
        return this.noneMatch.contains(Tag.ALL) || this.match.contains(Tag.ALL) || this.match.isEmpty() && this.unModifiedSince == null || this.noneMatch.isEmpty() && this.modifiedSince == null;
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getMatch().isEmpty()) {
            headers = headers.add(new Header("If-Match", this.buildTagHeaderValue(this.getMatch())));
        }
        if (!this.getNoneMatch().isEmpty()) {
            headers = headers.add(new Header("If-None-Match", this.buildTagHeaderValue(this.getNoneMatch())));
        }
        if (this.modifiedSince != null) {
            headers = headers.set(HeaderUtils.toHttpDate("If-Modified-Since", this.modifiedSince));
        }
        if (this.unModifiedSince != null) {
            headers = headers.set(HeaderUtils.toHttpDate("If-Unmodified-Since", this.unModifiedSince));
        }
        return headers;
    }

    public static Conditionals valueOf(Headers headers) {
        ImmutableList<Tag> ifMatch = Conditionals.makeTags(headers.getFirstHeaderValue("If-Match"));
        ImmutableList<Tag> ifNoneMatch = Conditionals.makeTags(headers.getFirstHeaderValue("If-None-Match"));
        DateTime modifiedSince = HeaderUtils.fromHttpDate(headers.getFirstHeader("If-Modified-Since"));
        DateTime unModifiedSince = HeaderUtils.fromHttpDate(headers.getFirstHeader("If-Unmodified-Since"));
        return new Conditionals((List<Tag>)ifMatch, (List<Tag>)ifNoneMatch, modifiedSince, unModifiedSince);
    }

    private static ImmutableList<Tag> makeTags(String ifMatch) {
        if (ifMatch == null) {
            return ImmutableList.of();
        }
        return ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)ifMatch), tagFunction));
    }

    private String buildTagHeaderValue(List<Tag> match) {
        return Joiner.on((String)",").join((Iterable)Collections2.transform(match, (Function)new Function<Tag, String>(){

            public String apply(Tag input) {
                return input.format();
            }
        }));
    }
}

