/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import org.codehaus.httpcache4j.Directive;
import org.codehaus.httpcache4j.Directives;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.util.DirectivesParser;
import org.codehaus.httpcache4j.util.NumberUtils;

public class CacheControl {
    private final Directives directives;

    public CacheControl(String value) {
        this(DirectivesParser.parse(value));
    }

    public CacheControl(Header header) {
        if (header == null) {
            header = new Header("Cache-Control", "");
        }
        if (!"Cache-Control".equalsIgnoreCase(header.getName())) {
            throw new IllegalArgumentException("Not a Cache-Control header");
        }
        this.directives = header.getDirectives();
    }

    public CacheControl(Directives directives) {
        this.directives = directives;
    }

    public boolean isPrivate() {
        return this.directives.hasDirective("private");
    }

    public int getMaxAge() {
        return NumberUtils.toInt(this.directives.get("max-age"), -1);
    }

    public int getSMaxAge() {
        return NumberUtils.toInt(this.directives.get("s-maxage"), -1);
    }

    public boolean isPublic() {
        return this.directives.hasDirective("public");
    }

    public int getMaxStale() {
        return NumberUtils.toInt(this.directives.get("max-stale"), -1);
    }

    public int getMinFresh() {
        return NumberUtils.toInt(this.directives.get("min-fresh"), -1);
    }

    public boolean isOnlyIfCached() {
        return this.directives.hasDirective("only-if-cached");
    }

    public boolean isNoTransform() {
        return this.directives.hasDirective("no-transform");
    }

    public boolean isMustRevalidate() {
        return this.directives.hasDirective("must-revalidate");
    }

    public boolean isProxyRevalidate() {
        return this.directives.hasDirective("proxy-revalidate");
    }

    public boolean isNoStore() {
        return this.directives.hasDirective("no-store");
    }

    public boolean isNoCache() {
        return this.directives.hasDirective("no-cache");
    }

    public Directives getDirectives() {
        return this.directives;
    }

    public Header toHeader() {
        return new Header("Cache-Control", new Directives(this.directives));
    }

    public static class Builder {
        private Directives directives = new Directives();

        public Builder noCache() {
            this.addDirective("no-cache");
            return this;
        }

        public Builder noStore() {
            this.addDirective("no-store");
            return this;
        }

        public Builder noTransform() {
            this.addDirective("no-transform");
            return this;
        }

        public Builder proxyRevalidate() {
            this.addDirective("proxy-revalidate");
            return this;
        }

        public Builder mustRevalidate() {
            this.addDirective("must-revalidate");
            return this;
        }

        public Builder onlyIfCached() {
            this.addDirective("only-if-cached");
            return this;
        }

        public Builder maxAge(int maxAge) {
            this.addDirective("max-age", String.valueOf(maxAge));
            return this;
        }

        public Builder sharedMaxAge(int maxAge) {
            this.addDirective("s-maxage", String.valueOf(maxAge));
            return this;
        }

        public Builder minFresh(int maxAge) {
            this.addDirective("min-fresh", String.valueOf(maxAge));
            return this;
        }

        public Builder maxStale(int maxAge) {
            this.addDirective("max-stale", String.valueOf(maxAge));
            return this;
        }

        public Builder withPublic() {
            this.addDirective("public");
            return this;
        }

        public Builder withPrivate() {
            this.addDirective("private");
            return this;
        }

        public CacheControl build() {
            return new CacheControl(this.directives);
        }

        private void addDirective(String name) {
            this.addDirective(name, null);
        }

        private void addDirective(String name, String value) {
            this.directives = this.directives.add(new Directive(name, value));
        }
    }
}

