/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Parameter;
import org.codehaus.httpcache4j.payload.Payload;
import org.codehaus.httpcache4j.util.URIEncoder;

public class FormDataPayload
implements Payload {
    private final MIMEType mimeType = new MIMEType("application/x-www-form-urlencoded");
    private final String value;

    public FormDataPayload(Map<String, List<String>> parameters) {
        this(FormDataPayload.toIterable(parameters));
    }

    private static Iterable<FormParameter> toIterable(Map<String, List<String>> parameters) {
        Preconditions.checkNotNull(parameters, (Object)"Parameters map may not be null");
        ArrayList<FormParameter> params = new ArrayList<FormParameter>();
        for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
            params.addAll(FormDataPayload.convert(entry.getKey(), entry.getValue()));
        }
        return params;
    }

    private static List<FormParameter> convert(final String key, List<String> values) {
        return Lists.transform(values, (Function)new Function<String, FormParameter>(){

            public FormParameter apply(String from) {
                return new FormParameter(key, from);
            }
        });
    }

    public FormDataPayload(Iterable<FormParameter> parameters) {
        this.value = Joiner.on((String)"&").skipNulls().join(parameters);
    }

    @Override
    public MIMEType getMimeType() {
        return this.mimeType;
    }

    @Override
    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.value.getBytes(Charsets.UTF_8));
    }

    @Deprecated
    public String getValues() {
        return this.value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public long length() {
        return this.value.length();
    }

    public static class FormParameter
    extends Parameter {
        private static final long serialVersionUID = -174492565886663398L;

        public FormParameter(String key, String value) {
            super(key, value);
        }

        private String encode(String value) {
            return URIEncoder.encodeUTF8(value);
        }

        @Override
        public String toString() {
            return this.encode(this.name) + "=" + this.encode(this.value);
        }
    }
}

