/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.httpcache4j.Directive;

public class Directives
implements Iterable<Directive>,
Serializable {
    private final Map<String, Directive> directives;

    public Directives(Iterable<Directive> directives) {
        LinkedHashMap<String, Directive> directivesMap = new LinkedHashMap<String, Directive>();
        for (Directive directive : directives) {
            directivesMap.put(directive.getName(), directive);
        }
        this.directives = Collections.unmodifiableMap(directivesMap);
    }

    public Directives() {
        this.directives = Collections.emptyMap();
    }

    public boolean hasDirective(String key) {
        return this.directives.containsKey(key);
    }

    public String get(String key) {
        Directive directive = this.directives.get(key);
        if (directive == null) {
            return "";
        }
        return directive.getValue();
    }

    public Directive getAsDirective(String key) {
        return this.directives.get(key);
    }

    public int size() {
        return this.directives.size();
    }

    @Override
    public Iterator<Directive> iterator() {
        return ImmutableList.copyOf(this.directives.values()).iterator();
    }

    public String toString() {
        return Joiner.on((String)", ").join(this.directives.values());
    }

    public Directives add(Directive directive) {
        ImmutableList.Builder dirs = ImmutableList.builder();
        dirs.addAll((Iterable)this);
        dirs.add((Object)directive);
        return new Directives((Iterable<Directive>)dirs.build());
    }
}

