/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.auth.mac;

import com.google.common.base.Strings;
import java.net.URI;
import org.codehaus.httpcache4j.HTTPRequest;
import org.codehaus.httpcache4j.auth.mac.Algorithm;
import org.codehaus.httpcache4j.auth.mac.Nonce;

public final class RequestMAC {
    private final String key;
    private final Nonce nonce;
    private final String ext;
    static final String NEWLINE = "\n";

    public RequestMAC(String key, Nonce nonce, String ext) {
        this.key = key;
        this.nonce = nonce;
        this.ext = Strings.isNullOrEmpty((String)ext) ? "" : ext;
    }

    public String getKey() {
        return this.key;
    }

    public Nonce getNonce() {
        return this.nonce;
    }

    public String getExt() {
        return this.ext;
    }

    String toNormalizedRequestString(HTTPRequest request) {
        int port;
        long ts = request.getRequestTime().getMillis() / 1000L;
        URI requestURI = request.getRequestURI();
        StringBuilder pathBuilder = new StringBuilder(requestURI.getRawPath());
        if (requestURI.getQuery() != null) {
            pathBuilder.append("?").append(requestURI.getRawQuery());
        }
        if ((port = requestURI.getPort()) == -1) {
            if ("http".equals(requestURI.getScheme())) {
                port = 80;
            } else if ("https".equals(requestURI.getScheme())) {
                port = 443;
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ts);
        sb.append(NEWLINE).append(this.nonce.format());
        sb.append(NEWLINE).append(request.getMethod().getMethod()).append(NEWLINE).append((CharSequence)pathBuilder);
        sb.append(NEWLINE).append(requestURI.getHost()).append(NEWLINE).append(port);
        sb.append(NEWLINE).append(this.ext).append(NEWLINE);
        return sb.toString();
    }

    public String getMac(HTTPRequest request, Algorithm algorithm) {
        return algorithm.encode(this.key, this.toNormalizedRequestString(request));
    }

    public String toHeaderValue(HTTPRequest request, String id, Algorithm algorithm) {
        long ts = request.getRequestTime().getMillis() / 1000L;
        return String.format("MAC id=\"%s\", ts=\"%s\", nonce=\"%s\", mac=\"%s\"", id, ts, this.nonce.format(), this.getMac(request, algorithm));
    }
}

