/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.codehaus.httpcache4j.auth.Authenticator;
import org.codehaus.httpcache4j.auth.DefaultAuthenticator;
import org.codehaus.httpcache4j.auth.DefaultProxyAuthenticator;
import org.codehaus.httpcache4j.auth.ProxyAuthenticator;
import org.codehaus.httpcache4j.util.PropertiesLoader;

public class ResolverConfiguration {
    public static final String DEFAULT_USER_AGENT = "HTTPCache4j " + ResolverConfiguration.getVersionFromProperties();
    private final String userAgent;
    private final boolean useChunked;
    private final ProxyAuthenticator proxyAuthenticator;
    private final Authenticator authenticator;

    private static String getVersionFromProperties() {
        Properties properties = PropertiesLoader.get(ResolverConfiguration.class.getResourceAsStream("/version.properties"));
        String version = properties.getProperty("version");
        if (StringUtils.isBlank((String)version) || version.contains("${")) {
            return "Development";
        }
        return version;
    }

    public ResolverConfiguration(String userAgent, boolean useChunked, ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        Validate.notNull((Object)proxyAuthenticator, (String)"Proxy Authenticator may not be null");
        Validate.notNull((Object)authenticator, (String)"Authenticator may not be null");
        Validate.notNull((Object)userAgent, (String)"User Agent may not be null");
        this.userAgent = userAgent;
        this.useChunked = useChunked;
        this.proxyAuthenticator = proxyAuthenticator;
        this.authenticator = authenticator;
    }

    public ResolverConfiguration(ProxyAuthenticator proxyAuthenticator, Authenticator authenticator) {
        this(DEFAULT_USER_AGENT, false, proxyAuthenticator, authenticator);
    }

    public ResolverConfiguration() {
        this(DEFAULT_USER_AGENT, false, new DefaultProxyAuthenticator(), new DefaultAuthenticator());
    }

    public ResolverConfiguration(String userAgent, boolean useChunked) {
        this(userAgent, useChunked, new DefaultProxyAuthenticator(), new DefaultAuthenticator());
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public boolean isUseChunked() {
        return this.useChunked;
    }

    public ProxyAuthenticator getProxyAuthenticator() {
        return this.proxyAuthenticator;
    }

    public Authenticator getAuthenticator() {
        return this.authenticator;
    }
}

