/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.resolver;

import java.io.InputStream;
import org.codehaus.httpcache4j.HTTPResponse;
import org.codehaus.httpcache4j.Header;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.Status;
import org.codehaus.httpcache4j.StatusLine;
import org.codehaus.httpcache4j.payload.InputStreamPayload;

public final class ResponseCreator {
    public HTTPResponse createResponse(Status status, Headers responseHeaders, InputStream stream) {
        return this.createResponse(new StatusLine(status), responseHeaders, stream);
    }

    public HTTPResponse createResponse(StatusLine line, Headers responseHeaders, InputStream stream) {
        Header contentTypeHeader = responseHeaders.getFirstHeader("Content-Type");
        MIMEType type = contentTypeHeader != null ? MIMEType.valueOf(contentTypeHeader.getValue()) : MIMEType.APPLICATION_OCTET_STREAM;
        InputStreamPayload payload = null;
        if (line.getStatus().isBodyContentAllowed() && stream != null) {
            payload = new InputStreamPayload(stream, type);
        }
        return new HTTPResponse(payload, line, responseHeaders);
    }
}

