/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preference<T> {
    private final T preference;
    private final double quality;

    public Preference(T preference) {
        this(preference, 1.0);
    }

    public Preference(T preference, double quality) {
        Validate.notNull(preference, (String)"Preference may not be null, use a ALL preference instead.");
        Validate.isTrue((quality <= 1.0 && quality > 0.0 ? 1 : 0) != 0, (String)"Quality is a percentage ranging from 0.0, to 1.0");
        this.preference = preference;
        this.quality = quality;
    }

    public T getPreference() {
        return this.preference;
    }

    public double getQuality() {
        return this.quality;
    }

    public String toString() {
        StringBuilder headerValue = new StringBuilder();
        if (this.getQuality() != 1.0) {
            headerValue.append(this.getStringValue()).append(";q=").append(this.getQuality());
        } else {
            headerValue.append(this.getStringValue());
        }
        return headerValue.toString();
    }

    protected String getStringValue() {
        return this.getPreference().toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Preference that = (Preference)o;
        return !(this.preference != null ? !this.preference.equals(that.preference) : that.preference != null);
    }

    public int hashCode() {
        return this.preference != null ? this.preference.hashCode() : 0;
    }
}

