/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.payload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.payload.Payload;

public class ByteArrayPayload
implements Payload,
Serializable {
    private static final long serialVersionUID = -4845254892809632007L;
    private byte[] bytes;
    private MIMEType type;

    public ByteArrayPayload(InputStream stream, MIMEType type) throws IOException {
        this.bytes = IOUtils.toByteArray((InputStream)stream);
        this.type = type;
    }

    public MIMEType getMimeType() {
        return this.type;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.bytes);
    }

    public boolean isAvailable() {
        return this.bytes != null && this.bytes.length > 0;
    }

    public boolean isTransient() {
        return false;
    }
}

