/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.httpcache4j.preference;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.codehaus.httpcache4j.HTTPUtils;
import org.codehaus.httpcache4j.Headers;
import org.codehaus.httpcache4j.MIMEType;
import org.codehaus.httpcache4j.preference.CharsetPreference;
import org.codehaus.httpcache4j.preference.LocalePreference;
import org.codehaus.httpcache4j.preference.MIMETypePreference;
import org.codehaus.httpcache4j.preference.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Preferences {
    private List<Preference<Locale>> acceptLocales = new ArrayList<Preference<Locale>>();
    private List<Preference<MIMEType>> acceptMIMETypes = new ArrayList<Preference<MIMEType>>();
    private List<Preference<String>> acceptCharset = new ArrayList<Preference<String>>();

    public void addLocale(Locale locale) {
        LocalePreference preference = new LocalePreference(locale);
        if (!this.acceptLocales.contains(preference)) {
            this.acceptLocales.add(preference);
        }
    }

    public void addMIMEType(MIMEType mimeType) {
        MIMETypePreference mime = new MIMETypePreference(mimeType);
        if (!this.acceptMIMETypes.contains(mime)) {
            this.acceptMIMETypes.add(mime);
        }
    }

    public void addCharset(String charset) {
        CharsetPreference preference = new CharsetPreference(charset);
        if (!this.acceptCharset.contains(preference)) {
            this.acceptCharset.add(preference);
        }
    }

    public List<Preference<Locale>> getAcceptLocales() {
        return this.acceptLocales;
    }

    public List<Preference<MIMEType>> getAcceptMIMETypes() {
        return this.acceptMIMETypes;
    }

    public List<Preference<String>> getAcceptCharset() {
        return this.acceptCharset;
    }

    public Headers toHeaders() {
        Headers headers = new Headers();
        if (!this.getAcceptMIMETypes().isEmpty()) {
            headers.add(HTTPUtils.toHeader("Accept", this.getAcceptMIMETypes()));
        } else if (!this.getAcceptLocales().isEmpty()) {
            headers.add(HTTPUtils.toHeader("Accept-Language", this.getAcceptLocales()));
        } else if (!this.getAcceptCharset().isEmpty()) {
            headers.add(HTTPUtils.toHeader("Accept-Charset", this.getAcceptCharset()));
        }
        return headers;
    }
}

