/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.lang.GroovyRuntimeException;
import groovy.net.xmlrpc.RPCServer;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.List;
import org.codehaus.groovy.runtime.InvokerInvocationException;
import uk.co.wilson.net.MinMLSocketServer;
import uk.co.wilson.net.MinMLThreadPool;
import uk.co.wilson.net.http.MinMLHTTPServer;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;

public class XMLRPCServer
extends RPCServer {
    private byte[] base64 = new byte[600];
    protected static final String xmlDeclaration = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n";
    protected static final byte[] userAgent = "User-Agent: Groovy XML-RPC\r\n".getBytes();
    protected static final byte[] contentTypeXML = "Content-Type: text/xml\r\n".getBytes();
    protected static final byte[] contentLength = "Content-Length: ".getBytes();
    protected MinMLSocketServer server;
    protected final int minWorkers;
    protected final int maxWorkers;
    protected final int maxKeepAlives;
    protected final int workerIdleLife;
    protected final int socketReadTimeout;
    protected final boolean detectEncoding;

    public byte[] getBase64() {
        return this.base64;
    }

    public XMLRPCServer(int n, int n2, int n3, int n4, int n5, boolean bl) {
        for (int i = 0; i != this.base64.length; ++i) {
            this.base64[i] = (byte)i;
        }
        this.server = null;
        this.minWorkers = n;
        this.maxWorkers = n2;
        this.maxKeepAlives = n3;
        this.workerIdleLife = n4;
        this.socketReadTimeout = n5;
        this.detectEncoding = bl;
    }

    public XMLRPCServer(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3, n4, n5, false);
    }

    public XMLRPCServer(boolean bl) {
        this(2, 10, 8, 60000, 60000, bl);
    }

    public XMLRPCServer() {
        this(false);
    }

    public void startServer(ServerSocket serverSocket) throws IOException {
        if (this.server != null) {
            this.stopServer();
        }
        final MinMLHTTPServer minMLHTTPServer = new MinMLHTTPServer(serverSocket, this.minWorkers, this.maxWorkers, this.maxKeepAlives, this.workerIdleLife, this.socketReadTimeout){

            protected MinMLThreadPool.Worker makeNewWorker() {
                return new MinMLHTTPServer.HTTPWorker(){

                    protected void processPost(InputStream inputStream, OutputStream outputStream, String string, String string2) throws Exception {
                        try {
                            XMLRPCMessageProcessor xMLRPCMessageProcessor = new XMLRPCMessageProcessor();
                            outputStream.write(string2.getBytes());
                            outputStream.write(okMessage);
                            outputStream.write(userAgent);
                            outputStream.write(host);
                            outputStream.write(contentTypeXML);
                            this.writeKeepAlive(outputStream);
                            outputStream.write(contentLength);
                            if (XMLRPCServer.this.detectEncoding) {
                                xMLRPCMessageProcessor.parseMessage(inputStream);
                            } else {
                                xMLRPCMessageProcessor.parseMessage(new InputStreamReader(inputStream, "ISO-8859-1"));
                            }
                            String string3 = xMLRPCMessageProcessor.getMethodname();
                            List list = xMLRPCMessageProcessor.getParams();
                            Closure closure = (Closure)XMLRPCServer.this.registeredMethods.get(string3);
                            Object object = null;
                            if (XMLRPCServer.this.preCallMethod != null) {
                                XMLRPCServer.this.preCallMethod.call(new Object[]{string3, list.toArray()});
                            }
                            if (closure == null) {
                                if (XMLRPCServer.this.defaultMethod == null) {
                                    throw new GroovyRuntimeException("Method " + string3 + " is not supported on this server");
                                }
                                object = XMLRPCServer.this.defaultMethod.call(new Object[]{string3, list.toArray()});
                            } else {
                                object = closure.call(list.toArray());
                            }
                            if (object == null) {
                                object = new Integer(0);
                            }
                            if (XMLRPCServer.this.postCallMethod != null) {
                                XMLRPCServer.this.postCallMethod.call(new Object[]{string3, object});
                            }
                            byte[] byArray = XMLRPCMessageProcessor.emitResult(new StringBuffer(XMLRPCServer.xmlDeclaration), object).toString().getBytes("ISO-8859-1");
                            outputStream.write(String.valueOf(byArray.length).getBytes());
                            outputStream.write(endOfLine);
                            outputStream.write(endOfLine);
                            outputStream.write(byArray);
                        }
                        catch (Throwable throwable) {
                            int n;
                            String string4;
                            Throwable throwable2;
                            if (throwable instanceof InvokerInvocationException) {
                                throwable2 = ((InvokerInvocationException)throwable).getCause();
                            }
                            if (throwable2 instanceof XMLRPCFailException) {
                                string4 = ((XMLRPCFailException)throwable2).getFaultString();
                                n = ((XMLRPCFailException)throwable2).getFaultCode();
                            } else {
                                string4 = throwable2.getMessage();
                                n = 0;
                            }
                            if (XMLRPCServer.this.faultMethod != null) {
                                try {
                                    XMLRPCServer.this.faultMethod.call(new Object[]{string4, new Integer(n)});
                                }
                                catch (Throwable throwable3) {
                                    // empty catch block
                                }
                            }
                            byte[] byArray = XMLRPCMessageProcessor.emitError(new StringBuffer(XMLRPCServer.xmlDeclaration), n, string4 == null ? throwable2.getClass().getName() : string4).toString().getBytes("ISO-8859-1");
                            outputStream.write(String.valueOf(byArray.length).getBytes());
                            outputStream.write(endOfLine);
                            outputStream.write(endOfLine);
                            outputStream.write(byArray);
                        }
                    }
                };
            }
        };
        this.server = minMLHTTPServer;
        Thread thread = new Thread(){

            public void run() {
                minMLHTTPServer.start();
            }
        };
        thread.setDaemon(false);
        thread.setName("XML-RPC Server main thread");
        thread.start();
    }

    public void stopServer() throws IOException {
        this.server.shutDown();
    }
}

