/*
 * Decompiled with CFR 0.152.
 */
package groovy.net.xmlrpc;

import groovy.lang.Closure;
import groovy.net.xmlrpc.JabberRPCException;
import groovy.net.xmlrpc.RPCServerProxy;
import groovy.net.xmlrpc.XMLRPCCallFailureException;
import groovy.net.xmlrpc.XMLRPCMessageProcessor;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.smackx.packet.JabberRPC;

public class JabberRPCServerProxy
extends RPCServerProxy {
    private final XMPPConnection connection;
    private final String to;

    public JabberRPCServerProxy(XMPPConnection xMPPConnection, String string) {
        this.connection = xMPPConnection;
        this.to = string;
        this.connection.sendPacket((Packet)new Presence(Presence.Type.available, "Jabber.RPC Client", 1, Presence.Mode.available));
    }

    public Object invokeMethod(String string, Object object) {
        if ("invokeMethod".equals(string)) {
            return super.invokeMethod(string, object);
        }
        Object[] objectArray = object instanceof List ? ((List)object).toArray() : (Object[])object;
        int n = objectArray.length;
        if (n != 0 && objectArray[n - 1] instanceof Closure) {
            --n;
        }
        try {
            final JabberRPC jabberRPC = new JabberRPC(XMLRPCMessageProcessor.emitCall(new StringBuffer(), string, objectArray, n).toString());
            PacketCollector packetCollector = this.connection.createPacketCollector(new PacketFilter(){

                public boolean accept(Packet packet) {
                    return packet instanceof JabberRPC && ((JabberRPC)packet).getType() == IQ.Type.RESULT && packet.getPacketID().equals(jabberRPC.getPacketID());
                }
            });
            jabberRPC.setType(IQ.Type.SET);
            jabberRPC.setTo(this.getId(this.connection.getRoster(), this.to));
            jabberRPC.setFrom(this.connection.getUser());
            this.connection.sendPacket((Packet)jabberRPC);
            JabberRPC jabberRPC2 = (JabberRPC)packetCollector.nextResult(20000L);
            packetCollector.cancel();
            if (jabberRPC2 == null) {
                throw new XMLRPCCallFailureException("call timed out", new Integer(0));
            }
            XMLRPCMessageProcessor xMLRPCMessageProcessor = new XMLRPCMessageProcessor();
            xMLRPCMessageProcessor.parseMessage(jabberRPC2.getChildElementXML());
            List list = xMLRPCMessageProcessor.getParams();
            if (list == null) {
                throw new XMLRPCCallFailureException("Empty response from server", new Integer(0));
            }
            if (n == objectArray.length) {
                return list.get(0);
            }
            Closure closure = (Closure)objectArray[n];
            closure.setDelegate((Object)this);
            return closure.call(new Object[]{list.get(0)});
        }
        catch (IOException iOException) {
            throw new XMLRPCCallFailureException(iOException.getMessage(), new Integer(0));
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw new XMLRPCCallFailureException(xMLRPCFailException.getFaultString(), xMLRPCFailException.getCause());
        }
    }

    private String getId(Roster roster, String string) {
        String string2;
        block5: {
            int n = 20;
            string2 = string;
            while (true) {
                Iterator iterator = roster.getPresences(string);
                int n2 = Integer.MIN_VALUE;
                if (iterator != null) {
                    while (iterator.hasNext()) {
                        Presence presence = (Presence)iterator.next();
                        if (presence.getPriority() <= n2) continue;
                        string2 = presence.getFrom();
                        n2 = presence.getPriority();
                    }
                }
                if (n2 >= 0) break block5;
                if (n-- <= 0) break;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            throw new JabberRPCException("User " + string2 + " not available");
        }
        return string2;
    }
}

