/*
 * Decompiled with CFR 0.152.
 */
package uk.co.wilson.net.xmlrpc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.AttributeList;
import org.xml.sax.SAXException;
import uk.co.wilson.net.xmlrpc.XMLRPCFailException;
import uk.co.wilson.xml.MinML;

public class XMLRPCMessageProcessor
extends MinML {
    private static final String startResponse = "<methodResponse>\n\t<params>\n\t\t<param>\n";
    private static final String endResponse = "\n\t\t</param>\n\t</params>\n</methodResponse>";
    private static final String startError = "<methodResponse>\n\t<fault>\n\t\t<value>\n\t\t\t<struct>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultCode</name>\n\t\t\t\t\t<value><int>";
    private static final String middleError = "</int></value>\n\t\t\t\t</member>\n\t\t\t\t<member>\n\t\t\t\t\t<name>faultString</name>\n\t\t\t\t\t<value><string>";
    private static final String endError = "</string></value>\n\t\t\t\t</member>\n\t\t\t</struct>\n\t\t</value>\n\t</fault>\n</methodResponse>\n";
    private static final byte[] translateTable = "BBBBBBBBBBAABBABBBBBBBBBBBBBBBBBABBBBBBBBBB>BBB?456789:;<=BBB@BBB\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b\t\n\u000b\f\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019BBBBBB\u001a\u001b\u001c\u001d\u001e\u001f !\"#$%&'()*+,-./0123".getBytes();
    protected static final Map elements = new HashMap();
    private Object params = null;
    private Object name = null;
    private String methodName = null;
    private Map struct = null;
    private List array = null;
    private Boolean inArray = Boolean.FALSE;
    private Stack aggregateStack = new Stack();
    private boolean gotValue = false;
    private final StringBuffer buffer = new StringBuffer();
    private final DateFormat dateTime = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    private final DateFormat dateTime1 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private final Boolean[] bools = new Boolean[]{Boolean.FALSE, Boolean.TRUE};
    static /* synthetic */ Class class$java$lang$Object;

    public static StringBuffer emitCall(StringBuffer stringBuffer, String string, Object[] objectArray, int n) throws XMLRPCFailException {
        XMLRPCMessageProcessor.encodeString(stringBuffer.append("<methodCall>\n\t<methodName>"), string).append("</methodName>\n\t<params>\n");
        for (int i = 0; i != n; ++i) {
            XMLRPCMessageProcessor.emit(stringBuffer.append("\t\t<param>"), objectArray[i]).append("</param>\n");
        }
        return stringBuffer.append("\t</params>\n</methodCall>\n");
    }

    public static StringBuffer emitResult(StringBuffer stringBuffer, Object object) throws XMLRPCFailException {
        stringBuffer.append(startResponse);
        XMLRPCMessageProcessor.emit(stringBuffer, object);
        stringBuffer.append(endResponse);
        return stringBuffer;
    }

    public static StringBuffer emitError(StringBuffer stringBuffer, int n, String string) throws XMLRPCFailException {
        stringBuffer.append(startError);
        XMLRPCMessageProcessor.emit(stringBuffer, String.valueOf(n));
        stringBuffer.append(middleError);
        XMLRPCMessageProcessor.emit(stringBuffer, string);
        stringBuffer.append(endError);
        return stringBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static StringBuffer emit(StringBuffer stringBuffer, Object object) throws XMLRPCFailException {
        if (object == null) {
            throw new XMLRPCFailException("an XML-RPC data value cannot be null", 0);
        }
        Emitter emitter = (Emitter)elements.get(object.getClass());
        if (emitter == null) {
            if (object instanceof List) {
                Iterator iterator = ((List)object).iterator();
                stringBuffer.append("<value><array><data>");
                while (iterator.hasNext()) {
                    XMLRPCMessageProcessor.emit(stringBuffer, iterator.next());
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < objectArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, objectArray[i]);
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof int[]) {
                int[] nArray = (int[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < nArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Integer(nArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof long[]) {
                long[] lArray = (long[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < lArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Long(lArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof short[]) {
                short[] sArray = (short[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < sArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Short(sArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof char[]) {
                char[] cArray = (char[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < cArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Character(cArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof float[]) {
                float[] fArray = (float[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < fArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Float(fArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof double[]) {
                double[] dArray = (double[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < dArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Double(dArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof boolean[]) {
                boolean[] blArray = (boolean[])object;
                stringBuffer.append("<value><array><data>");
                for (int i = 0; i < blArray.length; ++i) {
                    XMLRPCMessageProcessor.emit(stringBuffer, new Boolean(blArray[i]));
                }
                stringBuffer.append("</data></array></value>");
                return stringBuffer;
            }
            if (object instanceof Map) {
                Iterator iterator = ((Map)object).entrySet().iterator();
                stringBuffer.append("<value><struct>");
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object k = entry.getKey();
                    if (k == null) {
                        throw new XMLRPCFailException("the name of a struct element cannot be null", 0);
                    }
                    XMLRPCMessageProcessor.emit(XMLRPCMessageProcessor.encodeString(stringBuffer.append("<member><name>"), k.toString()).append("</name>"), entry.getValue()).append("</member>");
                }
                stringBuffer.append("</struct></value>");
                return stringBuffer;
            }
            Class<?> clazz = object.getClass();
            while (true) {
                Emitter emitter2;
                if ((emitter2 = (Emitter)elements.get(clazz)) != null) {
                    emitter2.emit(stringBuffer, object);
                    return stringBuffer;
                }
                if (clazz == (class$java$lang$Object == null ? XMLRPCMessageProcessor.class$("java.lang.Object") : class$java$lang$Object)) {
                    throw new XMLRPCFailException(object.getClass() + " is not a supported XML-RPC data type", 0);
                }
                clazz = clazz.getSuperclass();
            }
        }
        emitter.emit(stringBuffer, object);
        return stringBuffer;
    }

    public static StringBuffer encodeString(StringBuffer stringBuffer, String string) throws XMLRPCFailException {
        for (int i = 0; i != string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= ' ' || c == '\t' || c == '\n' || c == '\r') {
                if (c == '>') {
                    stringBuffer.append("&gt;");
                    continue;
                }
                if (c == '<') {
                    stringBuffer.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    stringBuffer.append("&amp;");
                    continue;
                }
                if (c > '\u00ff') {
                    if (c > '\ud800' && (c < '\ue000' || c >= '\ufffe')) {
                        throw new XMLRPCFailException("Can't include character with value 0x" + Integer.toHexString(c) + " in a well formed XML document", 0);
                    }
                    stringBuffer.append("&#x").append(Integer.toHexString(c)).append(';');
                    continue;
                }
                stringBuffer.append(c);
                continue;
            }
            throw new XMLRPCFailException("Can't include character with value 0x" + Integer.toHexString(c) + " in a well formed XML document", 0);
        }
        return stringBuffer;
    }

    public void parseMessage(String string) throws IOException, XMLRPCFailException {
        try {
            this.parse(new StringReader(string));
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw xMLRPCFailException;
        }
        catch (SAXException sAXException) {
            throw new XMLRPCFailException("XML error in response from remote system: " + sAXException.getMessage(), 0);
        }
    }

    public void parseMessage(InputStream inputStream) throws IOException, XMLRPCFailException {
        try {
            this.parse(new InputStreamReader(inputStream, "ISO-8859-1"));
        }
        catch (XMLRPCFailException xMLRPCFailException) {
            throw xMLRPCFailException;
        }
        catch (SAXException sAXException) {
            throw new XMLRPCFailException("XML error in response from remote system: " + sAXException.getMessage(), 0);
        }
    }

    public List getParams() {
        return (List)this.params;
    }

    public String getMethodname() {
        return this.methodName;
    }

    public void startElement(String string, AttributeList attributeList) {
        if ("value".equals(string) || "name".equals(string) || "methodName".equals(string)) {
            this.buffer.setLength(0);
            this.gotValue = false;
            this.aggregateStack.push(this.inArray);
            this.inArray = Boolean.FALSE;
        } else if ("struct".equals(string)) {
            this.aggregateStack.push(this.struct);
            this.aggregateStack.push(this.name);
            this.struct = new HashMap();
        } else if ("array".equals(string) || "params".equals(string)) {
            this.aggregateStack.push(this.inArray);
            this.inArray = Boolean.TRUE;
            this.aggregateStack.push(this.array);
            this.array = new ArrayList();
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.buffer.append(cArray, n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endElement(String string) throws SAXException {
        if ("value".equals(string)) {
            if (!this.gotValue) {
                this.params = this.buffer.toString();
                this.gotValue = true;
            }
            this.inArray = (Boolean)this.aggregateStack.pop();
            if (this.inArray.booleanValue()) {
                this.array.add(this.params);
            }
        } else if ("string".equals(string)) {
            this.params = this.buffer.toString();
            this.gotValue = true;
        } else if ("i4".equals(string) || "int".equals(string)) {
            this.params = new Integer(this.buffer.toString());
            this.gotValue = true;
        } else if ("boolean".equals(string)) {
            try {
                this.params = this.bools[Integer.parseInt(this.buffer.toString())];
            }
            catch (RuntimeException runtimeException) {
                throw new XMLRPCFailException("bad Boolean value: " + this.buffer.toString(), 0);
            }
            this.gotValue = true;
        } else if ("dateTime.iso8601".equals(string)) {
            try {
                XMLRPCMessageProcessor xMLRPCMessageProcessor = this;
                synchronized (xMLRPCMessageProcessor) {
                    this.params = this.dateTime.parse(this.buffer.toString());
                }
            }
            catch (ParseException parseException) {
                try {
                    XMLRPCMessageProcessor xMLRPCMessageProcessor = this;
                    synchronized (xMLRPCMessageProcessor) {
                        this.params = this.dateTime1.parse(this.buffer.toString());
                    }
                }
                catch (ParseException parseException2) {
                    throw new XMLRPCFailException(parseException.getMessage(), 0);
                }
            }
            this.gotValue = true;
        } else if ("base64".equals(string)) {
            int n = 0;
            int n2 = 4;
            int n3 = 0;
            boolean bl = false;
            for (int i = 0; i != this.buffer.length(); ++i) {
                int n4;
                char c = this.buffer.charAt(i);
                int n5 = n4 = c < '{' ? translateTable[c] : 66;
                if (n4 < 64) {
                    if (bl) {
                        throw new XMLRPCFailException("= character not at end of base64 value", 0);
                    }
                    n3 = n3 << 6 | n4;
                    if (n2-- != 4) {
                        this.buffer.setCharAt(n++, (char)(n3 >> n2 * 2 & 0xFF));
                    }
                } else if (n4 == 64) {
                    --n2;
                    bl = true;
                } else if (n4 == 66) {
                    throw new XMLRPCFailException("bad character in base64 value", 0);
                }
                if (n2 != 0) continue;
                n2 = 4;
            }
            this.buffer.setLength(n);
            try {
                this.params = this.buffer.toString().getBytes("ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new XMLRPCFailException("Base 64 decode produced byte values > 255", 0);
            }
            this.gotValue = true;
        } else if ("double".equals(string)) {
            this.params = new BigDecimal(this.buffer.toString());
            this.gotValue = true;
        } else if ("name".equals(string)) {
            this.name = this.buffer.toString();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("member".equals(string)) {
            this.struct.put(this.name, this.params);
        } else if ("struct".equals(string)) {
            this.params = this.struct;
            this.name = (String)this.aggregateStack.pop();
            this.struct = (Map)this.aggregateStack.pop();
        } else if ("array".equals(string) || "params".equals(string)) {
            this.params = this.array;
            this.array = (List)this.aggregateStack.pop();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("methodName".equals(string)) {
            this.methodName = this.buffer.toString();
            this.inArray = (Boolean)this.aggregateStack.pop();
        } else if ("fault".equals(string)) {
            String string2;
            int n;
            Object v = ((Map)this.params).get("faultCode");
            Object v2 = ((Map)this.params).get("faultString");
            if (v instanceof Integer) {
                n = (Integer)v;
                string2 = v2.toString();
            } else {
                n = 0;
                string2 = v2.toString() + " : " + v.toString();
            }
            throw new XMLRPCFailException(string2, n);
        }
    }

    static {
        final char[] cArray = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".toCharArray();
        elements.put(Integer.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) {
                stringBuffer.append("<value><i4>").append(object).append("</i4></value>");
            }
        });
        elements.put(Character.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) {
                stringBuffer.append("<value><i4>").append((int)((Character)object).charValue()).append("</i4></value>");
            }
        });
        elements.put(Byte.class, elements.get(Integer.class));
        elements.put(Short.class, elements.get(Integer.class));
        elements.put(Long.class, elements.get(Integer.class));
        elements.put(BigInteger.class, elements.get(Integer.class));
        elements.put(Double.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) {
                stringBuffer.append("<value><double>").append(object).append("</double></value>");
            }
        });
        elements.put(Float.class, elements.get(Double.class));
        elements.put(BigDecimal.class, elements.get(Double.class));
        elements.put(String.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) throws XMLRPCFailException {
                XMLRPCMessageProcessor.encodeString(stringBuffer.append("<value><string>"), object.toString()).append("</string></value>");
            }
        });
        elements.put(Boolean.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) {
                stringBuffer.append("<value><boolean>").append((Boolean)object != false ? "1" : "0").append("</boolean></value>");
            }
        });
        elements.put([B.class, new Emitter(){

            public void emit(StringBuffer stringBuffer, Object object) {
                int n;
                int n2 = 0;
                byte[] byArray = (byte[])object;
                int n3 = (byArray.length + 2) / 3 * 4;
                int n4 = byArray.length / 3 * 3;
                stringBuffer.ensureCapacity(n3 + 128 + byArray.length / 54);
                stringBuffer.append("<value><base64>\n");
                for (n = 0; n != n4; n += 3) {
                    int n5 = (byArray[n] & 0xFF) << 16 | (byArray[n + 1] & 0xFF) << 8 | byArray[n + 2] & 0xFF;
                    stringBuffer.append(cArray[n5 >> 18]);
                    stringBuffer.append(cArray[n5 >> 12 & 0x3F]);
                    stringBuffer.append(cArray[n5 >> 6 & 0x3F]);
                    stringBuffer.append(cArray[n5 & 0x3F]);
                    if (++n2 != 18) continue;
                    stringBuffer.append('\n');
                    n2 = 0;
                }
                if (n4 != byArray.length) {
                    n = (byArray[n4] & 0xFF) << 16;
                    if (n4 + 1 != byArray.length) {
                        n |= (byArray[n4 + 1] & 0xFF) << 8;
                    }
                    stringBuffer.append(cArray[n >> 18]);
                    stringBuffer.append(cArray[n >> 12 & 0x3F]);
                    stringBuffer.append(n4 + 1 < byArray.length ? cArray[n >> 6 & 0x3F] : (char)'=');
                    stringBuffer.append('=');
                }
                stringBuffer.append("\n</base64></value>");
            }
        });
        elements.put(Date.class, new Emitter(){
            private final DateFormat dateTime = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");

            public synchronized void emit(StringBuffer stringBuffer, Object object) {
                stringBuffer.append("<value><dateTime.iso8601>").append(this.dateTime.format((Date)object)).append("</dateTime.iso8601></value>");
            }
        });
    }

    protected static interface Emitter {
        public void emit(StringBuffer var1, Object var2) throws XMLRPCFailException;
    }
}

