/*
 * Decompiled with CFR 0.152.
 */
package groovy.util;

import groovy.lang.Closure;
import groovy.lang.GroovyShell;
import groovy.test.GroovyAssert;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Logger;
import junit.framework.TestCase;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class GroovyTestCase
extends TestCase {
    protected static Logger log = Logger.getLogger(GroovyTestCase.class.getName());
    private static int counter;
    private static final int MAX_NESTED_EXCEPTIONS = 10;
    public static final String TEST_SCRIPT_NAME_PREFIX = "TestScript";
    private boolean useAgileDoxNaming = false;
    private static final ThreadLocal notYetImplementedFlag;

    public String getName() {
        if (this.useAgileDoxNaming) {
            return super.getName().substring(4).replaceAll("([A-Z])", " $1").toLowerCase();
        }
        return super.getName();
    }

    public String getMethodName() {
        return super.getName();
    }

    protected void assertArrayEquals(Object[] expected, Object[] value) {
        String message = "expected array: " + InvokerHelper.toString((Object)expected) + " value array: " + InvokerHelper.toString((Object)value);
        GroovyTestCase.assertNotNull((String)(message + ": expected should not be null"), (Object)expected);
        GroovyTestCase.assertNotNull((String)(message + ": value should not be null"), (Object)value);
        GroovyTestCase.assertEquals((String)message, (int)expected.length, (int)value.length);
        int size = expected.length;
        for (int i = 0; i < size; ++i) {
            GroovyTestCase.assertEquals("value[" + i + "] when " + message, expected[i], value[i]);
        }
    }

    protected void assertLength(int length, char[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertLength(int length, int[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertLength(int length, Object[] array) {
        GroovyTestCase.assertEquals((int)length, (int)array.length);
    }

    protected void assertContains(char expected, char[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != expected) continue;
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append(expected).append(" not in {");
        for (int i = 0; i < array.length; ++i) {
            message.append("'").append(array[i]).append("'");
            if (i >= array.length - 1) continue;
            message.append(", ");
        }
        message.append(" }");
        GroovyTestCase.fail((String)message.toString());
    }

    protected void assertContains(int expected, int[] array) {
        for (int anInt : array) {
            if (anInt != expected) continue;
            return;
        }
        StringBuffer message = new StringBuffer();
        message.append(expected).append(" not in {");
        for (int i = 0; i < array.length; ++i) {
            message.append("'").append(array[i]).append("'");
            if (i >= array.length - 1) continue;
            message.append(", ");
        }
        message.append(" }");
        GroovyTestCase.fail((String)message.toString());
    }

    protected void assertToString(Object value, String expected) {
        Object console = InvokerHelper.invokeMethod((Object)value, (String)"toString", null);
        GroovyTestCase.assertEquals("toString() on value: " + value, expected, console);
    }

    protected void assertInspect(Object value, String expected) {
        Object console = InvokerHelper.invokeMethod((Object)value, (String)"inspect", null);
        GroovyTestCase.assertEquals("inspect() on value: " + value, expected, console);
    }

    protected void assertScript(String script) throws Exception {
        GroovyShell shell = new GroovyShell();
        shell.evaluate(script, this.getTestClassName());
    }

    protected String getTestClassName() {
        return TEST_SCRIPT_NAME_PREFIX + this.getMethodName() + counter++ + ".groovy";
    }

    protected String shouldFail(Closure code) {
        return GroovyAssert.shouldFail(code).getMessage();
    }

    protected String shouldFail(Class clazz, Closure code) {
        return GroovyAssert.shouldFail(clazz, code).getMessage();
    }

    protected String shouldFailWithCause(Class clazz, Closure code) {
        return GroovyAssert.shouldFailWithCause(clazz, code).getMessage();
    }

    protected String fixEOLs(String value) {
        return value.replaceAll("(\\r\\n?)|\n", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean notYetImplemented(TestCase caller) {
        if (notYetImplementedFlag.get() != null) {
            return false;
        }
        notYetImplementedFlag.set(Boolean.TRUE);
        Method testMethod = GroovyTestCase.findRunningJUnitTestMethod(caller.getClass());
        try {
            log.info("Running " + testMethod.getName() + " as not yet implemented");
            testMethod.invoke((Object)caller, (Object[])new Class[0]);
            GroovyTestCase.fail((String)(testMethod.getName() + " is marked as not yet implemented but passes unexpectedly"));
        }
        catch (Exception e) {
            log.info(testMethod.getName() + " fails which is expected as it is not yet implemented");
        }
        finally {
            notYetImplementedFlag.set(null);
        }
        return true;
    }

    public boolean notYetImplemented() {
        return GroovyTestCase.notYetImplemented(this);
    }

    private static Method findRunningJUnitTestMethod(Class caller) {
        Class[] args = new Class[]{};
        Exception t = new Exception();
        for (int i = t.getStackTrace().length - 1; i >= 0; --i) {
            StackTraceElement element = t.getStackTrace()[i];
            if (!element.getClassName().equals(caller.getName())) continue;
            try {
                Method m = caller.getMethod(element.getMethodName(), args);
                if (!GroovyTestCase.isPublicTestMethod(m)) continue;
                return m;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        throw new RuntimeException("No JUnit test case method found in call stack");
    }

    private static boolean isPublicTestMethod(Method method) {
        String name = method.getName();
        Class<?>[] parameters = method.getParameterTypes();
        Class<?> returnType = method.getReturnType();
        return parameters.length == 0 && name.startsWith("test") && returnType.equals(Void.TYPE) && Modifier.isPublic(method.getModifiers());
    }

    public static void assertEquals(String message, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && DefaultTypeTransformation.compareEqual((Object)expected, (Object)actual)) {
            return;
        }
        GroovyTestCase.failNotEquals((String)message, (Object)expected, (Object)actual);
    }

    public static void assertEquals(Object expected, Object actual) {
        GroovyTestCase.assertEquals(null, expected, actual);
    }

    public static void assertEquals(String expected, String actual) {
        GroovyTestCase.assertEquals(null, (String)expected, (String)actual);
    }

    static {
        notYetImplementedFlag = new ThreadLocal();
    }
}

