/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.json.JsonException;
import groovy.json.JsonOutput;
import groovy.json.StreamingJsonDelegate;
import groovy.lang.Closure;
import groovy.lang.GroovyObjectSupport;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class StreamingJsonBuilder
extends GroovyObjectSupport {
    private Writer writer;

    public StreamingJsonBuilder(Writer writer) {
        this.writer = writer;
    }

    public StreamingJsonBuilder(Writer writer, Object content) throws IOException {
        this(writer);
        if (content != null) {
            writer.write(JsonOutput.toJson(content));
        }
    }

    public Object call(Map m) throws IOException {
        this.writer.write(JsonOutput.toJson(m));
        return m;
    }

    public Object call(List l) throws IOException {
        this.writer.write(JsonOutput.toJson(l));
        return l;
    }

    public Object call(Object ... args) throws IOException {
        return this.call(Arrays.asList(args));
    }

    public Object call(Collection coll, Closure c) throws IOException {
        StreamingJsonDelegate.writeCollectionWithClosure(this.writer, coll, c);
        return null;
    }

    public Object call(Closure c) throws IOException {
        this.writer.write("{");
        StreamingJsonDelegate.cloneDelegateAndGetContent(this.writer, c);
        this.writer.write("}");
        return null;
    }

    public Object invokeMethod(String name, Object args) {
        boolean notExpectedArgs = false;
        if (args != null && Object[].class.isAssignableFrom(args.getClass())) {
            Object[] arr = (Object[])args;
            try {
                if (arr.length == 0) {
                    this.writer.write(JsonOutput.toJson(Collections.singletonMap(name, Collections.emptyMap())));
                }
                if (arr.length == 1) {
                    if (arr[0] instanceof Closure) {
                        this.writer.write("{");
                        this.writer.write(JsonOutput.toJson(name));
                        this.writer.write(":");
                        this.call((Closure)arr[0]);
                        this.writer.write("}");
                    }
                    if (arr[0] instanceof Map) {
                        this.writer.write(JsonOutput.toJson(Collections.singletonMap(name, (Map)arr[0])));
                    }
                    notExpectedArgs = true;
                }
                if (arr.length == 2 && arr[0] instanceof Map && arr[1] instanceof Closure) {
                    this.writer.write("{");
                    this.writer.write(JsonOutput.toJson(name));
                    this.writer.write(":{");
                    boolean first = true;
                    Map map = (Map)arr[0];
                    for (Map.Entry it : map.entrySet()) {
                        if (!first) {
                            this.writer.write(",");
                        } else {
                            first = false;
                        }
                        Map.Entry entry = it;
                        this.writer.write(JsonOutput.toJson(entry.getKey()));
                        this.writer.write(":");
                        this.writer.write(JsonOutput.toJson(entry.getValue()));
                    }
                    StreamingJsonDelegate.cloneDelegateAndGetContent(this.writer, (Closure)arr[1], map.size() == 0);
                    this.writer.write("}}");
                }
                if (StreamingJsonDelegate.isCollectionWithClosure(arr)) {
                    this.writer.write("{");
                    this.writer.write(JsonOutput.toJson(name));
                    this.writer.write(":");
                    this.call((Collection)arr[0], (Closure)arr[1]);
                    this.writer.write("}");
                }
                notExpectedArgs = true;
            }
            catch (IOException ioe) {
                throw new JsonException(ioe);
            }
        } else {
            notExpectedArgs = true;
        }
        if (!notExpectedArgs) {
            return this;
        }
        throw new JsonException("Expected no arguments, a single map, a single closure, or a map and closure as arguments.");
    }
}

