/*
 * Decompiled with CFR 0.152.
 */
package groovy.json;

import groovy.io.LineColumnReader;
import groovy.json.JsonException;
import groovy.json.JsonLexer;
import groovy.json.JsonToken;
import groovy.json.JsonTokenType;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonSlurper {
    public Object parseText(String text) {
        if (text == null || text.length() == 0) {
            throw new IllegalArgumentException("The JSON input text should neither be null nor empty.");
        }
        return this.parse((Reader)new LineColumnReader((Reader)new StringReader(text)));
    }

    public Object parse(Reader reader) {
        Object content;
        JsonLexer lexer = new JsonLexer(reader);
        JsonToken token = lexer.nextToken();
        if (token.getType() == JsonTokenType.OPEN_CURLY) {
            content = this.parseObject(lexer);
        } else if (token.getType() == JsonTokenType.OPEN_BRACKET) {
            content = this.parseArray(lexer);
        } else {
            throw new JsonException("A JSON payload should start with " + JsonTokenType.OPEN_CURLY.getLabel() + " or " + JsonTokenType.OPEN_BRACKET.getLabel() + ".\n" + "Instead, '" + token.getText() + "' was found " + "on line: " + token.getStartLine() + ", " + "column: " + token.getStartColumn());
        }
        return content;
    }

    private List parseArray(JsonLexer lexer) {
        ArrayList<Object> content;
        block10: {
            JsonToken currentToken;
            content = new ArrayList<Object>();
            do {
                if ((currentToken = lexer.nextToken()) == null) {
                    throw new JsonException("Expected a value on line: " + lexer.getReader().getLine() + ", " + "column: " + lexer.getReader().getColumn() + ".\n" + "But got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.add(this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.add(this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.add(currentToken.getValue());
                } else {
                    if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) {
                        return content;
                    }
                    throw new JsonException("Expected a value, an array, or an object on line: " + currentToken.getStartLine() + ", " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
                }
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected " + JsonTokenType.CLOSE_BRACKET.getLabel() + " " + "or " + JsonTokenType.COMMA.getLabel() + " " + "on line: " + lexer.getReader().getLine() + ", " + "column: " + lexer.getReader().getColumn() + ".\n" + "But got an unterminated array.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_BRACKET) break block10;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or " + JsonTokenType.CLOSE_BRACKET.getLabel() + " " + "on line: " + currentToken.getStartLine() + " " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
        }
        return content;
    }

    private Map parseObject(JsonLexer lexer) {
        HashMap<String, Object> content;
        block14: {
            content = new HashMap<String, Object>();
            JsonToken previousToken = null;
            JsonToken currentToken = null;
            do {
                if ((currentToken = lexer.nextToken()) == null) {
                    throw new JsonException("Expected a String key on line: " + lexer.getReader().getLine() + ", " + "column: " + lexer.getReader().getColumn() + ".\n" + "But got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) {
                    return content;
                }
                if (currentToken.getType() != JsonTokenType.STRING) {
                    throw new JsonException("Expected " + JsonTokenType.STRING.getLabel() + " key " + "on line: " + currentToken.getStartLine() + ", " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
                }
                String mapKey = (String)currentToken.getValue();
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected a " + JsonTokenType.COLON.getLabel() + " " + "on line: " + lexer.getReader().getLine() + ", " + "column: " + lexer.getReader().getColumn() + ".\n" + "But got an unterminated object.");
                }
                if (currentToken.getType() != JsonTokenType.COLON) {
                    throw new JsonException("Expected " + JsonTokenType.COLON.getLabel() + " " + "on line: " + currentToken.getStartLine() + ", " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
                }
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected a value on line: " + lexer.getReader().getLine() + ", " + "column: " + lexer.getReader().getColumn() + ".\n" + "But got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.OPEN_CURLY) {
                    content.put(mapKey, this.parseObject(lexer));
                } else if (currentToken.getType() == JsonTokenType.OPEN_BRACKET) {
                    content.put(mapKey, this.parseArray(lexer));
                } else if (currentToken.getType().ordinal() >= JsonTokenType.NULL.ordinal()) {
                    content.put(mapKey, currentToken.getValue());
                } else {
                    throw new JsonException("Expected a value, an array, or an object on line: " + currentToken.getStartLine() + ", " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
                }
                previousToken = currentToken;
                currentToken = lexer.nextToken();
                if (currentToken == null) {
                    throw new JsonException("Expected " + JsonTokenType.CLOSE_CURLY.getLabel() + " or " + JsonTokenType.COMMA.getLabel() + " " + "on line: " + previousToken.getEndLine() + ", " + "column: " + previousToken.getEndColumn() + ".\n" + "But got an unterminated object.");
                }
                if (currentToken.getType() == JsonTokenType.CLOSE_CURLY) break block14;
            } while (currentToken.getType() == JsonTokenType.COMMA);
            throw new JsonException("Expected a value or " + JsonTokenType.CLOSE_CURLY.getLabel() + " " + "on line: " + currentToken.getStartLine() + ", " + "column: " + currentToken.getStartColumn() + ".\n" + "But got '" + currentToken.getText() + "' instead.");
        }
        return content;
    }
}

