/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.eclipse.compiler;

import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.compiler.AbstractCompiler;
import org.codehaus.plexus.compiler.CompilerConfiguration;
import org.codehaus.plexus.compiler.CompilerError;
import org.codehaus.plexus.compiler.CompilerException;
import org.codehaus.plexus.compiler.CompilerOutputStyle;
import org.eclipse.jdt.core.compiler.CompilationProgress;
import org.eclipse.jdt.internal.compiler.batch.Main;

public class GroovyEclipseCompiler
extends AbstractCompiler {
    boolean verbose;

    public GroovyEclipseCompiler() {
        super(CompilerOutputStyle.ONE_OUTPUT_FILE_PER_INPUT_FILE, ".groovy", ".class", null);
    }

    public List compile(CompilerConfiguration config) throws CompilerException {
        File destinationDir = new File(config.getOutputLocation());
        if (!destinationDir.exists()) {
            destinationDir.mkdirs();
        }
        config.setSourceFiles(null);
        config.addInclude("**/*.java");
        config.addInclude("**/*.groovy");
        String[] sourceFiles = GroovyEclipseCompiler.getSourceFiles((CompilerConfiguration)config);
        if (sourceFiles.length == 0) {
            this.getLogger().warn("No sources added to compile; skipping");
            return Collections.EMPTY_LIST;
        }
        this.getLogger().info("Using Groovy-Eclipse compiler to compile both Java and Groovy files");
        this.getLogger().info("Compiling " + sourceFiles.length + " " + "source file" + (sourceFiles.length == 1 ? "" : "s") + " to " + destinationDir.getAbsolutePath());
        ArrayList<String> args = new ArrayList<String>();
        String cp = AbstractCompiler.getPathString((List)config.getClasspathEntries());
        this.verbose = config.isVerbose();
        if (this.verbose) {
            this.getLogger().info("Classpath: " + cp);
        }
        if (cp.length() > 0) {
            args.add("-cp");
            args.add(cp);
        }
        if (config.getOutputLocation() != null && config.getOutputLocation().length() > 0) {
            args.add("-d");
            args.add(config.getOutputLocation());
        }
        args.add("-g");
        String source = config.getSourceVersion();
        args.add("-source");
        if (source != null && source.length() > 0) {
            args.add(source);
        } else {
            args.add("1.5");
        }
        String target = config.getTargetVersion();
        args.add("-target");
        if (target != null && target.length() > 0) {
            args.add(target);
        } else {
            args.add("1.5");
        }
        if (config.isShowWarnings()) {
            args.add("-nowarn");
        }
        for (Map.Entry entry : config.getCustomCompilerArguments().entrySet()) {
            Object key = entry.getKey();
            if (this.doesStartWithHyphen(key)) {
                args.add((String)key);
            } else {
                args.add("-" + key);
            }
            if (entry.getValue() == null) continue;
            args.add("\"" + entry.getValue() + "\"");
        }
        args.addAll(this.composeSourceFiles(sourceFiles));
        if (this.verbose) {
            args.add("-verbose");
        }
        if (this.verbose) {
            this.getLogger().info("All args: " + args);
        }
        Progress progress = new Progress();
        Main main = new Main(new PrintWriter(System.out), new PrintWriter(System.err), false, null, (CompilationProgress)progress);
        boolean result = main.compile(args.toArray(new String[args.size()]));
        return this.formatResult(main, result);
    }

    private boolean doesStartWithHyphen(Object key) {
        return key != null && String.class.isInstance(key) && ((String)key).startsWith("-");
    }

    private List formatResult(Main main, boolean result) {
        if (result) {
            return Collections.EMPTY_LIST;
        }
        String error = main.globalErrorsCount == 1 ? "error" : "errors";
        String warning = main.globalWarningsCount == 1 ? "warning" : "warnings";
        return Collections.singletonList(new CompilerError("Found " + main.globalErrorsCount + " " + error + " and " + main.globalWarningsCount + " " + warning + ".", true));
    }

    private List composeSourceFiles(String[] sourceFiles) {
        ArrayList<String> sources = new ArrayList<String>(sourceFiles.length);
        int i = 0;
        while (i < sourceFiles.length) {
            sources.add(sourceFiles[i]);
            ++i;
        }
        return sources;
    }

    public String[] createCommandLine(CompilerConfiguration config) throws CompilerException {
        return null;
    }

    private class Progress
    extends CompilationProgress {
        int numCompiled = 0;

        private Progress() {
        }

        public void begin(int arg0) {
        }

        public void done() {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setTaskName(String newTaskName) {
        }

        public void worked(int workIncrement, int remainingWork) {
            if (GroovyEclipseCompiler.this.verbose) {
                String file = remainingWork == 1 ? "file" : "files";
                GroovyEclipseCompiler.this.getLogger().info(String.valueOf(remainingWork) + " " + file + " left.");
            }
            ++this.numCompiled;
        }
    }
}

