/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.GenericsType;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.ImportNodeCompatibilityWrapper;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.AnnotationConstantExpression;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ArrayExpression;
import org.codehaus.groovy.ast.expr.AttributeExpression;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.BitwiseNegationExpression;
import org.codehaus.groovy.ast.expr.BooleanExpression;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ClosureListExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.ElvisOperatorExpression;
import org.codehaus.groovy.ast.expr.EmptyExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.FieldExpression;
import org.codehaus.groovy.ast.expr.GStringExpression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.MapEntryExpression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.MethodPointerExpression;
import org.codehaus.groovy.ast.expr.NotExpression;
import org.codehaus.groovy.ast.expr.PostfixExpression;
import org.codehaus.groovy.ast.expr.PrefixExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.RangeExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.SpreadMapExpression;
import org.codehaus.groovy.ast.expr.StaticMethodCallExpression;
import org.codehaus.groovy.ast.expr.TernaryExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.UnaryMinusExpression;
import org.codehaus.groovy.ast.expr.UnaryPlusExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.CatchStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.ForStatement;
import org.codehaus.groovy.ast.stmt.ReturnStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.classgen.BytecodeExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.jdt.groovy.model.GroovyCompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.groovy.search.GenericsMapper;
import org.eclipse.jdt.groovy.search.ITypeLookup;
import org.eclipse.jdt.groovy.search.ITypeRequestor;
import org.eclipse.jdt.groovy.search.TypeLookupResult;
import org.eclipse.jdt.groovy.search.VariableScope;
import org.eclipse.jdt.internal.core.DefaultWorkingCopyOwner;
import org.eclipse.jdt.internal.core.util.Util;

public class TypeInferencingVisitorWithRequestor
extends ClassCodeVisitorSupport {
    private final GroovyCompilationUnit unit;
    private final Stack<VariableScope> scopes;
    private final ITypeLookup[] lookups;
    private ITypeRequestor requestor;
    private IJavaElement enclosingElement;
    private ASTNode enclosingDeclarationNode;
    private BinaryExpression enclosingAssignment;
    private Stack<ASTNode> propertyExpression;
    private Stack<ClassNode> objectExpressionType;
    private Stack<ClassNode> propertyExpressionType;
    private Stack<ClassNode> propertyExpressionDeclaringType;
    private static final Set<String> dgmClosureMethods = new HashSet<String>();

    static {
        dgmClosureMethods.add("find");
        dgmClosureMethods.add("each");
        dgmClosureMethods.add("reverseEach");
        dgmClosureMethods.add("eachWithIndex");
        dgmClosureMethods.add("unique");
        dgmClosureMethods.add("every");
        dgmClosureMethods.add("collect");
        dgmClosureMethods.add("findAll");
        dgmClosureMethods.add("groupBy");
    }

    TypeInferencingVisitorWithRequestor(GroovyCompilationUnit unit, ITypeLookup[] lookups) {
        this.unit = unit;
        this.enclosingDeclarationNode = this.createModuleNode(unit);
        this.lookups = lookups;
        this.scopes = new Stack();
        this.propertyExpression = new Stack();
        this.objectExpressionType = new Stack();
        this.propertyExpressionType = new Stack();
        this.propertyExpressionDeclaringType = new Stack();
    }

    public void visitCompilationUnit(ITypeRequestor requestor) {
        if (this.enclosingDeclarationNode == null) {
            return;
        }
        this.requestor = requestor;
        this.enclosingElement = this.unit;
        VariableScope topLevelScope = new VariableScope(null, this.enclosingDeclarationNode, false);
        this.scopes.push(topLevelScope);
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            lookup.initialize(this.unit, topLevelScope);
            ++n2;
        }
        try {
            this.visitPackage(((ModuleNode)this.enclosingDeclarationNode).getPackage());
            this.visitImports((ModuleNode)this.enclosingDeclarationNode);
            try {
                IType[] types;
                IType[] iTypeArray = types = this.unit.getTypes();
                int n3 = types.length;
                n = 0;
                while (n < n3) {
                    IType type = iTypeArray[n];
                    this.visitJDT(type, requestor);
                    ++n;
                }
            }
            catch (JavaModelException e) {
                Util.log(e, "Error getting types for " + this.unit.getElementName());
            }
            this.scopes.pop();
        }
        catch (VisitCompleted e) {
        }
        catch (Exception e) {
            Util.log(e, "Error performing search for " + this.unit.getElementName());
        }
    }

    public void visitPackage(PackageNode p) {
    }

    public void visitJDT(IType type, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = type;
        ClassNode node = this.findClassWithName(this.createName(type));
        if (node == null) {
            return;
        }
        try {
            try {
                this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
                this.enclosingDeclarationNode = node;
                this.visitClassInternal(node);
                try {
                    ConstructorNode defConstructor;
                    boolean isEnum = type.isEnum();
                    IJavaElement[] iJavaElementArray = type.getChildren();
                    int n = iJavaElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IJavaElement child = iJavaElementArray[n2];
                        if (!isEnum || !this.shouldFilterEnumMember(child)) {
                            switch (child.getElementType()) {
                                case 9: {
                                    this.visitJDT((IMethod)child, requestor);
                                    break;
                                }
                                case 8: {
                                    this.visitJDT((IField)child, requestor);
                                    break;
                                }
                                case 7: {
                                    this.visitJDT((IType)child, requestor);
                                    break;
                                }
                            }
                        }
                        ++n2;
                    }
                    if (!type.getMethod(type.getElementName(), new String[0]).exists() && (defConstructor = this.findDefaultConstructor(node)) != null) {
                        this.visitConstructorOrMethod(defConstructor, true);
                    }
                }
                catch (JavaModelException e) {
                    Util.log(e, "Error getting children of " + type.getFullyQualifiedName());
                }
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private ConstructorNode findDefaultConstructor(ClassNode node) {
        List<ConstructorNode> constructors = node.getDeclaredConstructors();
        for (ConstructorNode constructor : constructors) {
            if (constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            return constructor;
        }
        return null;
    }

    private boolean shouldFilterEnumMember(IJavaElement child) {
        int type = child.getElementType();
        String name = child.getElementName();
        if (name.indexOf(36) >= 0) {
            return true;
        }
        return type == 9 ? (name.equals("next") || name.equals("previous")) && ((IMethod)child).getNumberOfParameters() == 0 : type == 9 && (name.equals("MIN_VALUE") || name.equals("MAX_VALUE"));
    }

    private String createName(IType type) {
        StringBuilder sb = new StringBuilder();
        sb.append(type.getElementName());
        while (type.getParent().getElementType() == 7) {
            sb.insert(0, '$');
            type = (IType)type.getParent();
            sb.insert(0, type.getElementName());
        }
        return sb.toString();
    }

    public void visitJDT(IField field, ITypeRequestor requestor) {
        List<MethodNode> lazyMethods;
        FieldNode fieldNode;
        ASTNode oldEnclosingNode;
        IJavaElement oldEnclosing;
        block14: {
            oldEnclosing = this.enclosingElement;
            oldEnclosingNode = this.enclosingDeclarationNode;
            this.enclosingElement = field;
            this.requestor = requestor;
            fieldNode = this.findFieldNode(field);
            if (fieldNode == null) {
                return;
            }
            this.enclosingDeclarationNode = fieldNode;
            this.scopes.push(new VariableScope(this.scopes.peek(), fieldNode, fieldNode.isStatic()));
            try {
                try {
                    this.visitField(fieldNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.enclosingDeclarationNode = oldEnclosingNode;
                    this.enclosingElement = oldEnclosing;
                    this.scopes.pop();
                    break block14;
                }
            }
            catch (Throwable throwable) {
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.enclosingElement = oldEnclosing;
                this.scopes.pop();
                throw throwable;
            }
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.enclosingElement = oldEnclosing;
            this.scopes.pop();
        }
        if (this.isLazy(fieldNode) && (lazyMethods = ((ClassNode)this.enclosingDeclarationNode).getDeclaredMethods("set$" + field.getElementName())).size() > 0) {
            MethodNode lazyMethod = lazyMethods.get(0);
            this.enclosingDeclarationNode = lazyMethod;
            this.requestor = requestor;
            this.scopes.push(new VariableScope(this.scopes.peek(), lazyMethod, lazyMethod.isStatic()));
            try {
                try {
                    this.visitConstructorOrMethod(lazyMethod, lazyMethod instanceof ConstructorNode);
                }
                catch (VisitCompleted vc) {
                    if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                        throw vc;
                    }
                    this.enclosingElement = oldEnclosing;
                    this.enclosingDeclarationNode = oldEnclosingNode;
                    this.scopes.pop();
                }
            }
            finally {
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
    }

    public void visitJDT(IMethod method, ITypeRequestor requestor) {
        IJavaElement oldEnclosing = this.enclosingElement;
        ASTNode oldEnclosingNode = this.enclosingDeclarationNode;
        this.enclosingElement = method;
        MethodNode methodNode = this.findMethodNode(method);
        if (methodNode == null) {
            return;
        }
        this.enclosingDeclarationNode = methodNode;
        this.requestor = requestor;
        this.scopes.push(new VariableScope(this.scopes.peek(), methodNode, methodNode.isStatic()));
        try {
            try {
                this.visitConstructorOrMethod(methodNode, method.isConstructor());
            }
            catch (VisitCompleted vc) {
                if (vc.status == ITypeRequestor.VisitStatus.STOP_VISIT) {
                    throw vc;
                }
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
            catch (JavaModelException e) {
                Util.log(e, "Exception visiting method " + method.getElementName() + " in class " + method.getParent().getElementName());
                this.enclosingElement = oldEnclosing;
                this.enclosingDeclarationNode = oldEnclosingNode;
                this.scopes.pop();
            }
        }
        finally {
            this.enclosingElement = oldEnclosing;
            this.enclosingDeclarationNode = oldEnclosingNode;
            this.scopes.pop();
        }
    }

    private void visitClassInternal(ClassNode node) {
        if (this.unit.getResolver() != null) {
            this.unit.getResolver().currentClass = node;
        }
        VariableScope scope = this.scopes.peek();
        scope.addVariable("this", node, node);
        this.visitAnnotations(node);
        TypeLookupResult result = null;
        result = new TypeLookupResult(node, node, node, TypeLookupResult.TypeConfidence.EXACT, scope);
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        if (!node.isEnum()) {
            this.visitGenerics(node);
            this.visitClassReference(node.getUnresolvedSuperClass());
        }
        ClassNode[] classNodeArray = node.getInterfaces();
        int n = classNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ClassNode intr = classNodeArray[n2];
            this.visitClassReference(intr);
            ++n2;
        }
        VariableScope currentScope = scope;
        for (MethodNode method : node.getMethods()) {
            if (method.getName().contains("$")) continue;
            currentScope.addVariable(method.getName(), method.getReturnType(), method.getDeclaringClass());
        }
        MethodNode clinit = node.getMethod("<clinit>", new Parameter[0]);
        if (clinit != null && clinit.getCode() instanceof BlockStatement) {
            for (Statement element : ((BlockStatement)clinit.getCode()).getStatements()) {
                FieldNode f;
                BinaryExpression bexpr;
                if (!(element instanceof ExpressionStatement) || !(((ExpressionStatement)element).getExpression() instanceof BinaryExpression) || !((bexpr = (BinaryExpression)((ExpressionStatement)element).getExpression()).getLeftExpression() instanceof FieldExpression) || (f = ((FieldExpression)bexpr.getLeftExpression()).getField()) == null || !f.isStatic() || bexpr.getRightExpression() == null) continue;
                VariableScope fieldScope = new VariableScope(currentScope, f, true);
                this.scopes.push(fieldScope);
                try {
                    bexpr.getRightExpression().visit(this);
                }
                finally {
                    this.scopes.pop();
                }
            }
        }
        for (Statement element : node.getObjectInitializerStatements()) {
            element.visit(this);
        }
        for (ConstructorNode constructor : node.getDeclaredConstructors()) {
            if (!constructor.isSynthetic() || constructor.getParameters() != null && constructor.getParameters().length != 0) continue;
            this.visitConstructor(constructor);
        }
    }

    public void visitField(FieldNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                ClassNode fieldType = node.getType();
                if (fieldType != node.getDeclaringClass()) {
                    this.visitClassReference(fieldType);
                }
                this.visitAnnotations(node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit(this);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitClassReference(ClassNode node) {
        if (node.isGenericsPlaceHolder()) {
            return;
        }
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                if (!node.isEnum()) {
                    this.visitGenerics(node);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private void visitGenerics(ClassNode node) {
        if (node.isUsingGenerics() && node.getGenericsTypes() != null) {
            GenericsType[] genericsTypeArray = node.getGenericsTypes();
            int n = genericsTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                GenericsType gen = genericsTypeArray[n2];
                if (gen.getLowerBound() != null) {
                    this.visitClassReference(gen.getLowerBound());
                }
                if (gen.getUpperBounds() != null) {
                    ClassNode[] classNodeArray = gen.getUpperBounds();
                    int n3 = classNodeArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ClassNode upper = classNodeArray[n4];
                        if (!upper.getName().equals(node.getName())) {
                            this.visitClassReference(upper);
                        }
                        ++n4;
                    }
                }
                if (gen.getType() != null && gen.getName().charAt(0) != '?') {
                    this.visitClassReference(gen.getType());
                }
                ++n2;
            }
        }
    }

    public void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                ASTNode[] aSTNodeArray;
                GenericsType[] gens = node.getGenericsTypes();
                if (gens != null) {
                    aSTNodeArray = gens;
                    int n3 = gens.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ASTNode gen = aSTNodeArray[n4];
                        if (((GenericsType)gen).getLowerBound() != null) {
                            this.visitClassReference(((GenericsType)gen).getLowerBound());
                        }
                        if (((GenericsType)gen).getUpperBounds() != null) {
                            ClassNode[] classNodeArray = ((GenericsType)gen).getUpperBounds();
                            int n5 = classNodeArray.length;
                            int n6 = 0;
                            while (n6 < n5) {
                                ClassNode upper = classNodeArray[n6];
                                this.visitClassReference(upper);
                                ++n6;
                            }
                        }
                        if (((GenericsType)gen).getType() != null && ((GenericsType)gen).getType().getName().charAt(0) != '?') {
                            this.visitClassReference(((GenericsType)gen).getType());
                        }
                        ++n4;
                    }
                }
                this.visitClassReference(node.getReturnType());
                if (node.getExceptions() != null) {
                    aSTNodeArray = node.getExceptions();
                    int n7 = aSTNodeArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        ASTNode e = aSTNodeArray[n8];
                        this.visitClassReference((ClassNode)e);
                        ++n8;
                    }
                }
                if (this.handleParameterList(node.getParameters())) {
                    super.visitConstructorOrMethod(node, isConstructor);
                }
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    public void visitAnnotations(AnnotatedNode node) {
        for (AnnotationNode annotation : node.getAnnotations()) {
            this.visitAnnotation(annotation);
        }
        super.visitAnnotations(node);
    }

    public void visitImports(ModuleNode node) {
        for (ImportNode imp : new ImportNodeCompatibilityWrapper(node).getAllImportNodes()) {
            TypeLookupResult result = null;
            IJavaElement oldEnclosingElement = this.enclosingElement;
            ClassNode type = imp.getType();
            if (type != null) {
                this.enclosingElement = this.unit.getImport(imp.getClassName().replace('$', '.'));
                if (!this.enclosingElement.exists()) {
                    this.enclosingElement = oldEnclosingElement;
                }
            }
            VariableScope scope = this.scopes.peek();
            ITypeLookup[] iTypeLookupArray = this.lookups;
            int n = this.lookups.length;
            int n2 = 0;
            while (n2 < n) {
                ITypeLookup lookup = iTypeLookupArray[n2];
                TypeLookupResult candidate = lookup.lookupType(imp, scope);
                if (candidate != null) {
                    if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                        result = candidate;
                    }
                    if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                }
                ++n2;
            }
            ITypeRequestor.VisitStatus status = this.handleRequestor(imp, this.requestor, result);
            this.enclosingElement = oldEnclosingElement;
            switch (status) {
                case CONTINUE: {
                    try {
                        if (type == null) break;
                        this.visitClassReference(type);
                        break;
                    }
                    catch (VisitCompleted e) {
                        if (e.status != ITypeRequestor.VisitStatus.STOP_VISIT) break;
                        throw e;
                    }
                }
                case CANCEL_BRANCH: 
                case CANCEL_MEMBER: {
                    return;
                }
                case STOP_VISIT: {
                    throw new VisitCompleted(status);
                }
            }
        }
    }

    private boolean handleStatement(Statement node) {
        VariableScope currentScope = this.scopes.peek();
        VariableScope.VariableInfo info = currentScope.lookupName("this");
        ClassNode declaring = info == null ? VariableScope.OBJECT_CLASS_NODE : info.declaringType;
        TypeLookupResult noLookup = new TypeLookupResult(declaring, declaring, declaring, TypeLookupResult.TypeConfidence.EXACT, currentScope);
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, noLookup);
        switch (status) {
            case CONTINUE: {
                return true;
            }
            case CANCEL_BRANCH: {
                return false;
            }
        }
        throw new VisitCompleted(status);
    }

    private boolean handleExpression(Expression node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ClassNode objectExprType = this.isProperty(node) ? this.objectExpressionType.pop() : null;
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope, objectExprType);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        result.enclosingAssignment = this.enclosingAssignment;
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        ClassNode rememberedDeclaringType = result.declaringType;
        if (scope.getCategoryNames().contains(rememberedDeclaringType)) {
            rememberedDeclaringType = objectExprType;
        }
        switch (status) {
            case CONTINUE: {
                if (this.isObjectExpression(node)) {
                    this.objectExpressionType.push(result.type);
                } else if (this.isProperty(node)) {
                    this.propertyExpressionType.push(result.type);
                    this.propertyExpressionDeclaringType.push(rememberedDeclaringType);
                }
                return true;
            }
            case CANCEL_BRANCH: {
                if (this.isObjectExpression(node)) {
                    this.objectExpressionType.push(result.type);
                } else if (this.isProperty(node)) {
                    this.propertyExpressionType.push(result.type);
                    this.propertyExpressionDeclaringType.push(rememberedDeclaringType);
                }
                return false;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
        return false;
    }

    private boolean handleParameterList(Parameter[] params) {
        if (params != null) {
            VariableScope scope = this.scopes.peek();
            Parameter[] parameterArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter node = parameterArray[n2];
                TypeLookupResult result = null;
                ITypeLookup[] iTypeLookupArray = this.lookups;
                int n3 = this.lookups.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITypeLookup lookup = iTypeLookupArray[n4];
                    lookup.lookupType(node, scope);
                    result = lookup.lookupType(node.getType(), scope);
                    TypeLookupResult candidate = lookup.lookupType(node.getType(), scope);
                    if (candidate != null) {
                        if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                            result = candidate;
                        }
                        if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
                    }
                    ++n4;
                }
                TypeLookupResult parameterResult = new TypeLookupResult(result.type, result.declaringType, node, TypeLookupResult.TypeConfidence.EXACT, scope);
                ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, parameterResult);
                switch (status) {
                    case CONTINUE: {
                        break;
                    }
                    case CANCEL_BRANCH: {
                        return false;
                    }
                    case CANCEL_MEMBER: 
                    case STOP_VISIT: {
                        throw new VisitCompleted(status);
                    }
                }
                this.visitClassReference(node.getType());
                this.visitAnnotations(node);
                Expression init = node.getInitialExpression();
                if (init != null) {
                    init.visit(this);
                }
                ++n2;
            }
        }
        return true;
    }

    public void visitVariableExpression(VariableExpression node) {
        boolean shouldContinue;
        this.scopes.peek().setCurrentNode(node);
        VariableExpression maybeAnnotatedNode = node;
        if (maybeAnnotatedNode instanceof AnnotatedNode) {
            this.visitAnnotations(maybeAnnotatedNode);
        }
        if (node.getAccessedVariable() == node) {
            this.visitClassReference(node.getType());
        }
        if (shouldContinue = this.handleExpression(node)) {
            super.visitVariableExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitArgumentlistExpression(ArgumentListExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitArgumentlistExpression(node);
        }
    }

    public void visitArrayExpression(ArrayExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitArrayExpression(node);
        }
    }

    public void visitAttributeExpression(AttributeExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            this.propertyExpression.push(node);
            super.visitAttributeExpression(node);
            this.propertyExpression.pop();
        }
    }

    public void visitBinaryExpression(BinaryExpression node) {
        Expression toVisitSecond;
        Expression toVisitFirst;
        BinaryExpression maybeAnnotatedNode = node;
        if (maybeAnnotatedNode instanceof AnnotatedNode) {
            this.visitAnnotations(maybeAnnotatedNode);
        }
        boolean isAssignment = node.getOperation().getText().equals("=");
        BinaryExpression oldEnclosingAssignment = this.enclosingAssignment;
        if (isAssignment) {
            this.enclosingAssignment = node;
        }
        this.propertyExpression.push(node);
        if (isAssignment) {
            toVisitFirst = node.getRightExpression();
            toVisitSecond = node.getLeftExpression();
        } else {
            toVisitFirst = node.getLeftExpression();
            toVisitSecond = node.getRightExpression();
        }
        toVisitFirst.visit(this);
        ClassNode objExprType = this.objectExpressionType.peek();
        boolean shouldContinue = this.handleExpression(node);
        ClassNode propType = this.propertyExpressionType.pop();
        this.propertyExpressionDeclaringType.pop();
        if (shouldContinue) {
            toVisitSecond.visit(this);
            this.propertyExpression.pop();
            if (this.isObjectExpression(node)) {
                this.objectExpressionType.push(this.findTypeOfBinaryExpression(node.getOperation().getText(), objExprType, propType));
            }
        } else {
            this.propertyExpression.pop();
            this.objectExpressionType.pop();
        }
        this.enclosingAssignment = oldEnclosingAssignment;
    }

    public void visitBitwiseNegationExpression(BitwiseNegationExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitBitwiseNegationExpression(node);
        }
    }

    public void visitBooleanExpression(BooleanExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitBooleanExpression(node);
        }
    }

    public void visitEmptyExpression(EmptyExpression node) {
        this.handleExpression(node);
    }

    public void visitBytecodeExpression(BytecodeExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitBytecodeExpression(node);
        }
    }

    public void visitCastExpression(CastExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            this.visitClassReference(node.getType());
            super.visitCastExpression(node);
        }
    }

    public void visitClassExpression(ClassExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitClassExpression(node);
        }
    }

    public void visitClosureExpression(ClosureExpression node) {
        VariableScope scope = new VariableScope(this.scopes.peek(), node, false);
        this.scopes.push(scope);
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            VariableScope.CallAndType cat;
            ClassNode implicitParamType = this.findImplicitParamType(scope);
            if (node.getParameters() != null && node.getParameters().length > 0) {
                this.handleParameterList(node.getParameters());
                Parameter firstParameter = node.getParameters()[0];
                if (implicitParamType != VariableScope.OBJECT_CLASS_NODE && firstParameter.getType().equals(VariableScope.OBJECT_CLASS_NODE)) {
                    firstParameter.setType(implicitParamType);
                    scope.addVariable(firstParameter);
                }
            } else if (implicitParamType != VariableScope.OBJECT_CLASS_NODE && !scope.containsInThisScope("it")) {
                scope.addVariable("it", implicitParamType, VariableScope.OBJECT_CLASS_NODE);
            }
            if ((cat = scope.getEnclosingMethodCallExpression()) != null) {
                scope.addVariable("this", cat.declaringType, cat.declaringType);
                scope.addVariable("super", cat.declaringType.getUnresolvedSuperClass(), cat.declaringType.getUnresolvedSuperClass());
            }
            super.visitClosureExpression(node);
        }
        this.scopes.pop();
    }

    private ClassNode findImplicitParamType(VariableScope scope) {
        VariableScope.CallAndType call = scope.getEnclosingMethodCallExpression();
        if (call != null && dgmClosureMethods.contains(call.call.getMethodAsString())) {
            return this.extractElementType(call.declaringType);
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    public void visitBlockStatement(BlockStatement block) {
        this.scopes.push(new VariableScope(this.scopes.peek(), block, false));
        boolean shouldContinue = this.handleStatement(block);
        if (shouldContinue) {
            super.visitBlockStatement(block);
        }
        this.scopes.pop();
    }

    public void visitReturnStatement(ReturnStatement ret) {
        boolean shouldContinue = this.handleStatement(ret);
        if (shouldContinue) {
            if (ret.getExpression() instanceof AnnotationConstantExpression) {
                this.visitClassReference(((AnnotationConstantExpression)ret.getExpression()).getType());
            }
            super.visitReturnStatement(ret);
        }
    }

    public void visitForLoop(ForStatement node) {
        this.propertyExpression.push(node);
        node.getCollectionExpression().visit(this);
        this.propertyExpression.pop();
        ClassNode collectionType = this.objectExpressionType.pop();
        this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
            if (param.getType().equals(VariableScope.OBJECT_CLASS_NODE)) {
                ClassNode extractedElementType = this.extractElementType(collectionType);
                this.scopes.peek().addVariable(param.getName(), extractedElementType, null);
            }
        }
        node.getLoopBlock().visit(this);
        this.scopes.pop();
    }

    private ClassNode extractElementType(ClassNode collectionType) {
        MethodNode entrySetMethod;
        if (collectionType.isArray()) {
            return collectionType.getComponentType();
        }
        MethodNode iterator = collectionType.getMethod("iterator", new Parameter[0]);
        ClassNode typeToResolve = null;
        if (iterator != null) {
            typeToResolve = iterator.getReturnType();
        }
        if (collectionType.declaresInterface(VariableScope.ITERATOR_CLASS) || collectionType.equals(VariableScope.ITERATOR_CLASS) || collectionType.declaresInterface(VariableScope.ENUMERATION_CLASS) || collectionType.equals(VariableScope.ENUMERATION_CLASS)) {
            typeToResolve = collectionType;
        } else if ((collectionType.declaresInterface(VariableScope.MAP_CLASS_NODE) || collectionType.equals(VariableScope.MAP_CLASS_NODE)) && (entrySetMethod = collectionType.getMethod("entrySet", new Parameter[0])) != null) {
            typeToResolve = entrySetMethod.getReturnType();
        }
        if (typeToResolve != null) {
            typeToResolve = VariableScope.clone(typeToResolve);
            ClassNode unresolvedCollectionType = collectionType.redirect();
            GenericsMapper mapper = GenericsMapper.gatherGenerics(collectionType, unresolvedCollectionType);
            ClassNode resolved = VariableScope.resolveTypeParameterization(mapper, typeToResolve);
            GenericsType[] resolvedReturnGenerics = resolved.getGenericsTypes();
            if (resolvedReturnGenerics != null && resolvedReturnGenerics.length > 0) {
                return resolvedReturnGenerics[0].getType();
            }
        }
        if (collectionType.declaresInterface(VariableScope.INPUT_STREAM_CLASS) || collectionType.declaresInterface(VariableScope.DATA_INPUT_STREAM_CLASS) || collectionType.equals(VariableScope.INPUT_STREAM_CLASS) || collectionType.equals(VariableScope.DATA_INPUT_STREAM_CLASS)) {
            return VariableScope.BYTE_CLASS_NODE;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    public void visitCatchStatement(CatchStatement node) {
        this.scopes.push(new VariableScope(this.scopes.peek(), node, false));
        Parameter param = node.getVariable();
        if (param != null) {
            this.handleParameterList(new Parameter[]{param});
        }
        super.visitCatchStatement(node);
        this.scopes.pop();
    }

    public void visitClosureListExpression(ClosureListExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitClosureListExpression(node);
        }
    }

    public void visitConstantExpression(ConstantExpression node) {
        this.scopes.peek().setCurrentNode(node);
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitConstantExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitConstructorCallExpression(ConstructorCallExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            this.visitClassReference(node.getType());
            super.visitConstructorCallExpression(node);
        }
    }

    public void visitDeclarationExpression(DeclarationExpression node) {
        this.visitBinaryExpression(node);
    }

    public void visitFieldExpression(FieldExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitFieldExpression(node);
        }
    }

    public void visitGStringExpression(GStringExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitGStringExpression(node);
        }
    }

    public void visitListExpression(ListExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitListExpression(node);
        }
    }

    public void visitMapEntryExpression(MapEntryExpression node) {
        this.scopes.peek().setCurrentNode(node);
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitMapEntryExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMapExpression(MapExpression node) {
        this.scopes.peek().setCurrentNode(node);
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitMapExpression(node);
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMethodCallExpression(MethodCallExpression node) {
        this.scopes.peek().setCurrentNode(node);
        this.propertyExpression.push(node);
        node.getObjectExpression().visit(this);
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            node.getMethod().visit(this);
            ClassNode propType = this.propertyExpressionType.pop();
            ClassNode propDeclaringType = this.propertyExpressionDeclaringType.pop();
            VariableScope.CallAndType call = new VariableScope.CallAndType(node, propDeclaringType);
            this.propertyExpression.pop();
            ClassNode catNode = this.isCategoryDeclaration(node);
            if (catNode != null) {
                this.addCategoryToBeDeclared(catNode);
            }
            VariableScope scope = this.scopes.peek();
            scope.addEnclosingMethodCall(call);
            node.getArguments().visit(this);
            scope.forgetEnclosingMethodCall();
            if (this.isObjectExpression(node)) {
                this.objectExpressionType.push(propType);
            }
        } else {
            this.propertyExpression.pop();
            this.objectExpressionType.pop();
        }
        this.scopes.peek().forgetCurrentNode();
    }

    public void visitMethodPointerExpression(MethodPointerExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitMethodPointerExpression(node);
        }
    }

    public void visitNotExpression(NotExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitNotExpression(node);
        }
    }

    public void visitPostfixExpression(PostfixExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitPostfixExpression(node);
        }
    }

    public void visitPrefixExpression(PrefixExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitPrefixExpression(node);
        }
    }

    public void visitPropertyExpression(PropertyExpression node) {
        this.propertyExpression.push(node);
        node.getObjectExpression().visit(this);
        boolean shouldContinue = node.getObjectExpression().getLength() > 0 ? this.handleExpression(node) : true;
        if (shouldContinue) {
            node.getProperty().visit(this);
            this.propertyExpressionDeclaringType.pop();
            this.propertyExpression.pop();
            ClassNode propType = this.propertyExpressionType.pop();
            if (this.isObjectExpression(node)) {
                this.objectExpressionType.push(propType);
            }
        } else {
            this.propertyExpression.pop();
            this.objectExpressionType.pop();
        }
    }

    public void visitRangeExpression(RangeExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitRangeExpression(node);
        }
    }

    public void visitShortTernaryExpression(ElvisOperatorExpression node) {
        this.propertyExpression.push(node);
        node.getTrueExpression().visit(this);
        boolean shouldContinue = this.handleExpression(node);
        ClassNode exprType = this.propertyExpressionType.pop();
        this.propertyExpressionDeclaringType.pop();
        this.propertyExpression.pop();
        if (shouldContinue) {
            node.getFalseExpression().visit(this);
            if (this.isObjectExpression(node)) {
                this.objectExpressionType.push(exprType);
            }
        } else {
            this.propertyExpression.pop();
        }
    }

    public void visitSpreadExpression(SpreadExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitSpreadExpression(node);
        }
    }

    public void visitSpreadMapExpression(SpreadMapExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitSpreadMapExpression(node);
        }
    }

    public void visitStaticMethodCallExpression(StaticMethodCallExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue && node.getEnd() > 0) {
            this.visitClassReference(node.getOwnerType());
            super.visitStaticMethodCallExpression(node);
        }
    }

    public void visitTernaryExpression(TernaryExpression node) {
        node.getBooleanExpression().visit(this);
        this.propertyExpression.push(node);
        node.getTrueExpression().visit(this);
        boolean shouldContinue = this.handleExpression(node);
        ClassNode exprType = this.propertyExpressionType.pop();
        this.propertyExpressionDeclaringType.pop();
        this.propertyExpression.pop();
        if (shouldContinue) {
            node.getFalseExpression().visit(this);
            if (this.isObjectExpression(node)) {
                this.objectExpressionType.push(exprType);
            }
        } else {
            this.propertyExpression.pop();
        }
    }

    public void visitTupleExpression(TupleExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitTupleExpression(node);
        }
    }

    public void visitUnaryMinusExpression(UnaryMinusExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitUnaryMinusExpression(node);
        }
    }

    public void visitUnaryPlusExpression(UnaryPlusExpression node) {
        boolean shouldContinue = this.handleExpression(node);
        if (shouldContinue) {
            super.visitUnaryPlusExpression(node);
        }
    }

    private void visitAnnotation(AnnotationNode node) {
        TypeLookupResult result = null;
        VariableScope scope = this.scopes.peek();
        ITypeLookup[] iTypeLookupArray = this.lookups;
        int n = this.lookups.length;
        int n2 = 0;
        while (n2 < n) {
            ITypeLookup lookup = iTypeLookupArray[n2];
            TypeLookupResult candidate = lookup.lookupType(node, scope);
            if (candidate != null) {
                if (result == null || result.confidence.isLessPreciseThan(candidate.confidence)) {
                    result = candidate;
                }
                if (TypeLookupResult.TypeConfidence.LOOSELY_INFERRED.isLessPreciseThan(result.confidence)) break;
            }
            ++n2;
        }
        ITypeRequestor.VisitStatus status = this.handleRequestor(node, this.requestor, result);
        switch (status) {
            case CONTINUE: {
                this.visitClassReference(node.getClassNode());
                if (node.getMembers() == null) break;
                Collection<Expression> exprs = node.getMembers().values();
                for (Expression expr : exprs) {
                    if (expr instanceof AnnotationConstantExpression) {
                        this.visitClassReference(((AnnotationConstantExpression)expr).getType());
                    }
                    expr.visit(this);
                }
                break;
            }
            case CANCEL_BRANCH: {
                return;
            }
            case CANCEL_MEMBER: 
            case STOP_VISIT: {
                throw new VisitCompleted(status);
            }
        }
    }

    private ITypeRequestor.VisitStatus handleRequestor(ASTNode node, ITypeRequestor requestor, TypeLookupResult result) {
        return requestor.acceptASTNode(node, result, this.enclosingElement);
    }

    private MethodNode findMethodNode(IMethod method) {
        ClassNode clazz = this.findClassWithName(this.createName(method.getDeclaringType()));
        try {
            if (method.isConstructor()) {
                List<ConstructorNode> constructors = clazz.getDeclaredConstructors();
                for (ConstructorNode constructorNode : constructors) {
                    Parameter[] groovyParams;
                    String[] jdtParamTypes = method.getParameterTypes() == null ? new String[]{} : method.getParameterTypes();
                    Parameter[] parameterArray = groovyParams = constructorNode.getParameters() == null ? new Parameter[]{} : constructorNode.getParameters();
                    if (groovyParams != null && groovyParams.length > 0 && groovyParams[0].getName().startsWith("$")) {
                        Parameter[] newGroovyParams = new Parameter[groovyParams.length - 1];
                        System.arraycopy(groovyParams, 1, newGroovyParams, 0, newGroovyParams.length);
                        groovyParams = newGroovyParams;
                    }
                    if (groovyParams.length != jdtParamTypes.length) continue;
                    int i = 0;
                    while (i < groovyParams.length) {
                        String groovyClassType = groovyParams[i].getType().getName();
                        if (!groovyClassType.startsWith("[")) {
                            groovyClassType = Signature.createTypeSignature(groovyClassType, false);
                        }
                        if (!groovyClassType.equals(jdtParamTypes[i])) {
                            // empty if block
                        }
                        ++i;
                    }
                    return constructorNode;
                }
            } else {
                List<MethodNode> methods = clazz.getMethods(method.getElementName());
                for (MethodNode methodNode : methods) {
                    Parameter[] groovyParams;
                    String[] jdtParamTypes = method.getParameterTypes() == null ? new String[]{} : method.getParameterTypes();
                    Parameter[] parameterArray = groovyParams = methodNode.getParameters() == null ? new Parameter[]{} : methodNode.getParameters();
                    if (groovyParams.length != jdtParamTypes.length) continue;
                    int i = 0;
                    while (i < groovyParams.length) {
                        String groovyClassType = groovyParams[i].getType().getName();
                        if (!groovyClassType.startsWith("[")) {
                            groovyClassType = Signature.createTypeSignature(groovyClassType, false);
                        }
                        if (!groovyClassType.equals(jdtParamTypes[i])) {
                            // empty if block
                        }
                        ++i;
                    }
                    return methodNode;
                }
            }
        }
        catch (JavaModelException e) {
            Util.log(e, "Exception finding method " + method.getElementName() + " in class " + clazz.getName());
        }
        return null;
    }

    private FieldNode findFieldNode(IField field) {
        ClassNode clazz = this.findClassWithName(this.createName(field.getDeclaringType()));
        FieldNode fieldNode = clazz.getField(field.getElementName());
        if (fieldNode == null) {
            fieldNode = clazz.getField("$" + field.getElementName());
        }
        return fieldNode;
    }

    private boolean isLazy(FieldNode field) {
        List<AnnotationNode> annotations = field.getAnnotations();
        for (AnnotationNode annotation : annotations) {
            if (!annotation.getClassNode().getName().equals("groovy.lang.Lazy")) continue;
            return true;
        }
        return false;
    }

    protected SourceUnit getSourceUnit() {
        return null;
    }

    private ClassNode findClassWithName(String simpleName) {
        for (ClassNode clazz : this.getModuleNode().getClasses()) {
            if (!clazz.getNameWithoutPackage().equals(simpleName)) continue;
            return clazz;
        }
        return null;
    }

    private ModuleNode createModuleNode(GroovyCompilationUnit unit) {
        if (unit.getOwner() == null || unit.owner == DefaultWorkingCopyOwner.PRIMARY) {
            return unit.getModuleNode();
        }
        return unit.getNewModuleNode();
    }

    private ModuleNode getModuleNode() {
        if (this.enclosingDeclarationNode instanceof ModuleNode) {
            return (ModuleNode)this.enclosingDeclarationNode;
        }
        if (this.enclosingDeclarationNode instanceof ClassNode) {
            return ((ClassNode)this.enclosingDeclarationNode).getModule();
        }
        if (this.enclosingDeclarationNode instanceof MethodNode) {
            return ((MethodNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        if (this.enclosingDeclarationNode instanceof FieldNode) {
            return ((FieldNode)this.enclosingDeclarationNode).getDeclaringClass().getModule();
        }
        throw new IllegalArgumentException("Invalid enclosing declaration node: " + this.enclosingDeclarationNode);
    }

    private boolean isObjectExpression(Expression node) {
        if (!this.propertyExpression.isEmpty()) {
            ASTNode maybeProperty = this.propertyExpression.peek();
            if (maybeProperty instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)maybeProperty;
                return prop.getObjectExpression() == node;
            }
            if (maybeProperty instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)maybeProperty;
                return prop.getObjectExpression() == node;
            }
            if (maybeProperty instanceof BinaryExpression) {
                BinaryExpression prop = (BinaryExpression)maybeProperty;
                boolean isAssignment = prop.getOperation().getText().equals("=");
                if (isAssignment) {
                    return prop.getRightExpression() == node;
                }
                return prop.getLeftExpression() == node;
            }
            if (maybeProperty instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)maybeProperty;
                return prop.getObjectExpression() == node;
            }
            if (maybeProperty instanceof TernaryExpression) {
                TernaryExpression prop = (TernaryExpression)maybeProperty;
                return prop.getTrueExpression() == node;
            }
            if (maybeProperty instanceof ForStatement) {
                ForStatement prop = (ForStatement)maybeProperty;
                return prop.getCollectionExpression() == node;
            }
            return false;
        }
        return false;
    }

    private boolean isProperty(Expression node) {
        if (!this.propertyExpression.isEmpty()) {
            ASTNode maybeProperty = this.propertyExpression.peek();
            if (maybeProperty instanceof PropertyExpression) {
                PropertyExpression prop = (PropertyExpression)maybeProperty;
                return prop.getProperty() == node;
            }
            if (maybeProperty instanceof MethodCallExpression) {
                MethodCallExpression prop = (MethodCallExpression)maybeProperty;
                return prop.getMethod() == node;
            }
            if (maybeProperty instanceof BinaryExpression || maybeProperty instanceof TernaryExpression) {
                return maybeProperty == node;
            }
            if (maybeProperty instanceof AttributeExpression) {
                AttributeExpression prop = (AttributeExpression)maybeProperty;
                return prop.getProperty() == node;
            }
            return false;
        }
        return false;
    }

    private ClassNode findTypeOfBinaryExpression(String operation, ClassNode lhs, ClassNode rhs) {
        char op = operation.charAt(0);
        switch (op) {
            case '[': {
                List<MethodNode> getAts = lhs.getMethods("getAt");
                for (MethodNode getAt : getAts) {
                    if (getAt.getParameters() == null || getAt.getParameters().length != 1) continue;
                    return getAt.getReturnType();
                }
                return VariableScope.deref(lhs);
            }
            case '%': 
            case '*': 
            case '-': 
            case '/': {
                return this.isNumeric(lhs) ? lhs : (this.isNumeric(rhs) ? rhs : VariableScope.NUMBER_CLASS_NODE);
            }
            case '+': {
                return lhs;
            }
            case '~': {
                return VariableScope.STRING_CLASS_NODE;
            }
            case '!': 
            case '&': 
            case '<': 
            case '>': 
            case '^': {
                if (operation.length() > 1) {
                    if (operation.equals("<<")) {
                        ClassNode listType = VariableScope.clone(VariableScope.LIST_CLASS_NODE);
                        listType.getGenericsTypes()[0].setType(rhs);
                        listType.getGenericsTypes()[0].setName(rhs.getName());
                    }
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                return lhs;
            }
            case '=': {
                if (operation.length() <= 1) break;
                if (operation.charAt(1) == '=') {
                    return VariableScope.BOOLEAN_CLASS_NODE;
                }
                if (operation.charAt(1) != '~') break;
                return VariableScope.STRING_CLASS_NODE;
            }
        }
        return rhs;
    }

    private boolean isNumeric(ClassNode c) {
        if (c == null || c.isInterface() || c == VariableScope.OBJECT_CLASS_NODE) {
            return false;
        }
        if (c.equals(VariableScope.NUMBER_CLASS_NODE)) {
            return true;
        }
        return this.isNumeric(c.getSuperClass());
    }

    private void addCategoryToBeDeclared(ClassNode catNode) {
        this.scopes.peek().setCategoryBeingDeclared(catNode);
    }

    private ClassNode isCategoryDeclaration(MethodCallExpression node) {
        ArgumentListExpression args;
        Expression exprs;
        String methodAsString = node.getMethodAsString();
        if (methodAsString != null && methodAsString.equals("use") && (exprs = node.getArguments()) instanceof ArgumentListExpression && (args = (ArgumentListExpression)exprs).getExpressions().size() >= 2 && args.getExpressions().get(1) instanceof ClosureExpression) {
            VariableScope.VariableInfo info;
            Expression expr = args.getExpressions().get(0);
            if (expr instanceof ClassExpression) {
                return expr.getType();
            }
            if (expr instanceof VariableExpression && expr.getText() != null && (info = this.scopes.peek().lookupName(expr.getText())) != null) {
                return info.type;
            }
        }
        return null;
    }

    public class VisitCompleted
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        public final ITypeRequestor.VisitStatus status;

        public VisitCompleted(ITypeRequestor.VisitStatus status) {
            this.status = status;
        }
    }
}

