/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.resources;

import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class LinkDescription
implements Comparable {
    public static final URI VIRTUAL_LOCATION = LinkDescription.getVirtualLocation();
    private URI localLocation;
    private IPath path;
    private int type;
    static /* synthetic */ Class class$0;

    private static URI getVirtualLocation() {
        try {
            return new URI("virtual:/virtual");
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public LinkDescription() {
        this.path = Path.EMPTY;
        this.type = -1;
    }

    public LinkDescription(IResource linkedResource, URI location) {
        Assert.isNotNull(linkedResource);
        Assert.isNotNull(location);
        this.type = linkedResource.getType();
        this.path = linkedResource.getProjectRelativePath();
        this.localLocation = location;
    }

    public boolean equals(Object o) {
        Class<?> clazz = o.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("org.eclipse.core.internal.resources.LinkDescription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz != clazz2) {
            return false;
        }
        LinkDescription other = (LinkDescription)o;
        return this.localLocation.equals(other.localLocation) && this.path.equals(other.path) && this.type == other.type;
    }

    public URI getLocationURI() {
        return this.localLocation;
    }

    public IPath getProjectRelativePath() {
        return this.path;
    }

    public int getType() {
        return this.type;
    }

    public boolean isGroup() {
        return this.localLocation.equals(VIRTUAL_LOCATION);
    }

    public int hashCode() {
        return this.type + this.path.hashCode() + this.localLocation.hashCode();
    }

    public void setLocationURI(URI location) {
        this.localLocation = location;
    }

    public void setPath(IPath path) {
        this.path = path;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int compareTo(Object o) {
        LinkDescription that = (LinkDescription)o;
        IPath path1 = this.getProjectRelativePath();
        IPath path2 = that.getProjectRelativePath();
        int count1 = path1.segmentCount();
        int compare = count1 - path2.segmentCount();
        if (compare != 0) {
            return compare;
        }
        int i = 0;
        while (i < count1) {
            compare = path1.segment(i).compareTo(path2.segment(i));
            if (compare != 0) {
                return compare;
            }
            ++i;
        }
        return 0;
    }
}

