/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen.asm;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.CastExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.ClassGeneratorException;
import org.codehaus.groovy.classgen.asm.BytecodeHelper;
import org.codehaus.groovy.classgen.asm.BytecodeVariable;
import org.codehaus.groovy.classgen.asm.CompileStack;
import org.codehaus.groovy.classgen.asm.MethodCaller;
import org.codehaus.groovy.classgen.asm.WriterController;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class OperandStack {
    private static final MethodCaller asTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "asType");
    private static final MethodCaller castToTypeMethod = MethodCaller.newStatic(ScriptBytecodeAdapter.class, "castToType");
    private WriterController controller;
    private ArrayList<ClassNode> stack = new ArrayList();

    public OperandStack(WriterController wc) {
        this.controller = wc;
    }

    public int getStackLength() {
        return this.stack.size();
    }

    public void popDownTo(int elements) {
        int last = this.stack.size();
        MethodVisitor mv = this.controller.getMethodVisitor();
        while (last > elements) {
            ClassNode element;
            if (this.isTwoSlotType(element = this.stack.remove(--last))) {
                mv.visitInsn(88);
                continue;
            }
            mv.visitInsn(87);
        }
    }

    private boolean isTwoSlotType(ClassNode type) {
        return type == ClassHelper.long_TYPE || type == ClassHelper.double_TYPE;
    }

    public void castToBool(int mark, boolean emptyDefault) {
        int size = this.stack.size();
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (mark == size) {
            if (emptyDefault) {
                mv.visitIntInsn(16, 1);
            } else {
                mv.visitIntInsn(16, 0);
            }
            this.stack.add(null);
        } else if (mark == this.stack.size() - 1) {
            ClassNode last = this.stack.get(size - 1);
            if (last == ClassHelper.boolean_TYPE) {
                return;
            }
            if (!ClassHelper.isPrimitiveType(last)) {
                BytecodeHelper.unbox(mv, ClassHelper.boolean_TYPE);
            } else {
                this.primitive2b(mv, last);
            }
        } else {
            throw new GroovyBugError("operand stack contains " + this.stack.size() + " elements, but we expected only " + mark);
        }
        this.stack.set(mark, ClassHelper.boolean_TYPE);
    }

    private void primitive2b(MethodVisitor mv, ClassNode type) {
        if (type == ClassHelper.double_TYPE) {
            mv.visitInsn(142);
            mv.visitInsn(145);
        } else if (type == ClassHelper.long_TYPE) {
            mv.visitInsn(136);
            mv.visitInsn(145);
        } else if (type == ClassHelper.float_TYPE) {
            mv.visitInsn(139);
            mv.visitInsn(145);
        } else if (type == ClassHelper.int_TYPE) {
            mv.visitInsn(145);
        }
    }

    public void pop() {
        this.popDownTo(this.stack.size() - 1);
    }

    public Label jump(int ifIns) {
        Label label = new Label();
        this.jump(ifIns, label);
        return label;
    }

    public void jump(int ifIns, Label label) {
        this.controller.getMethodVisitor().visitJumpInsn(ifIns, label);
        this.remove(1);
    }

    public void dup() {
        ClassNode type = this.getTopOperand();
        this.stack.add(type);
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (type == ClassHelper.double_TYPE || type == ClassHelper.long_TYPE) {
            mv.visitInsn(92);
        } else {
            mv.visitInsn(89);
        }
    }

    public ClassNode box() {
        int size;
        ClassNode type;
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (BytecodeHelper.box(mv, type = this.stack.get((size = this.stack.size()) - 1))) {
            type = ClassHelper.getWrapper(type);
            BytecodeHelper.doCast(mv, type);
        }
        this.stack.set(size - 1, type);
        return type;
    }

    public void remove(int amount) {
        int size = this.stack.size();
        for (int i = size - 1; i > size - 1 - amount; --i) {
            try {
                this.stack.remove(i);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException ai) {
                System.err.println("index problem in " + this.controller.getSourceUnit().getName());
                throw ai;
            }
        }
    }

    public void push(ClassNode type) {
        this.stack.add(type);
    }

    public void swap() {
        MethodVisitor mv = this.controller.getMethodVisitor();
        int size = this.stack.size();
        ClassNode b = this.stack.get(size - 1);
        ClassNode a = this.stack.get(size - 2);
        if (this.isTwoSlotType(a)) {
            if (this.isTwoSlotType(b)) {
                mv.visitInsn(94);
                mv.visitInsn(88);
            } else {
                mv.visitInsn(91);
                mv.visitInsn(87);
            }
        } else if (this.isTwoSlotType(b)) {
            mv.visitInsn(93);
            mv.visitInsn(88);
        } else {
            mv.visitInsn(95);
        }
        this.stack.set(size - 1, a);
        this.stack.set(size - 2, b);
    }

    public void replace(ClassNode type) {
        int size = this.stack.size();
        try {
            if (size == 0) {
                throw new ArrayIndexOutOfBoundsException("size==0");
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            System.err.println("index problem in " + this.controller.getSourceUnit().getName());
            throw ai;
        }
        this.stack.set(size - 1, type);
    }

    public void replace(ClassNode type, int n) {
        this.remove(n);
        this.push(type);
    }

    public void doGroovyCast(ClassNode targetType) {
        this.doConvertAndCast(targetType, false);
    }

    public void doGroovyCast(Variable v) {
        ClassNode targetType = v.getOriginType();
        this.doConvertAndCast(targetType, false);
    }

    public void doAsType(ClassNode targetType) {
        this.doConvertAndCast(targetType, true);
    }

    private void doConvertAndCast(ClassNode targetType, boolean coerce) {
        int size = this.stack.size();
        if (size == 0) {
            throw new ArrayIndexOutOfBoundsException("size==0");
        }
        ClassNode top = this.stack.get(size - 1);
        targetType = targetType.redirect();
        if (targetType == top) {
            return;
        }
        MethodVisitor mv = this.controller.getMethodVisitor();
        if (coerce) {
            if (top.isDerivedFrom(targetType)) {
                return;
            }
            this.box();
            new ClassExpression(targetType).visit(this.controller.getAcg());
            this.remove(1);
            asTypeMethod.call(mv);
            BytecodeHelper.doCast(mv, targetType);
            this.replace(targetType);
            return;
        }
        boolean primTarget = ClassHelper.isPrimitiveType(targetType);
        boolean primTop = ClassHelper.isPrimitiveType(top);
        if (primTop && primTarget) {
            this.box();
        } else if (primTop) {
            this.box();
            new ClassExpression(targetType).visit(this.controller.getAcg());
            this.remove(1);
            castToTypeMethod.call(mv);
        } else if (!primTarget && !top.isDerivedFrom(targetType)) {
            new ClassExpression(targetType).visit(this.controller.getAcg());
            this.remove(1);
            castToTypeMethod.call(mv);
        }
        BytecodeHelper.doCast(mv, targetType);
        this.replace(targetType);
    }

    public void pushConstant(ConstantExpression expression) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        Object value = expression.getValue();
        ClassNode type = expression.getType().redirect();
        boolean asPrimitive = ClassHelper.isPrimitiveType(type);
        if (value == null) {
            mv.visitInsn(1);
        } else if (asPrimitive) {
            mv.visitLdcInsn(value);
        } else if (value instanceof Character) {
            mv.visitLdcInsn(value);
            BytecodeHelper.box(mv, type);
        } else if (value instanceof Number) {
            if (value instanceof BigDecimal) {
                String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
                mv.visitTypeInsn(187, className);
                mv.visitInsn(89);
                mv.visitLdcInsn(value.toString());
                mv.visitMethodInsn(183, className, "<init>", "(Ljava/lang/String;)V");
            } else if (value instanceof BigInteger) {
                String className = BytecodeHelper.getClassInternalName(value.getClass().getName());
                mv.visitTypeInsn(187, className);
                mv.visitInsn(89);
                mv.visitLdcInsn(value.toString());
                mv.visitMethodInsn(183, className, "<init>", "(Ljava/lang/String;)V");
            } else if (value instanceof Long) {
                long l = (Long)value;
                if (l == 0L) {
                    mv.visitInsn(9);
                } else if (l == 1L) {
                    mv.visitInsn(10);
                } else {
                    mv.visitLdcInsn(value);
                }
                BytecodeHelper.box(mv, ClassHelper.getUnwrapper(type));
                BytecodeHelper.doCast(mv, type);
            } else {
                mv.visitLdcInsn(value);
                BytecodeHelper.box(mv, ClassHelper.getUnwrapper(type));
                BytecodeHelper.doCast(mv, type);
            }
        } else if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            String text = bool != false ? "TRUE" : "FALSE";
            mv.visitFieldInsn(178, "java/lang/Boolean", text, "Ljava/lang/Boolean;");
        } else if (value instanceof String) {
            mv.visitLdcInsn(value);
        } else {
            throw new ClassGeneratorException("Cannot generate bytecode for constant: " + value + " of type: " + type.getName());
        }
        this.push(type);
    }

    public void pushDynamicName(Expression name) {
        ConstantExpression ce;
        Object value;
        if (name instanceof ConstantExpression && (value = (ce = (ConstantExpression)name).getValue()) instanceof String) {
            this.pushConstant(ce);
            return;
        }
        new CastExpression(ClassHelper.STRING_TYPE, name).visit(this.controller.getAcg());
    }

    public void loadOrStoreVariable(BytecodeVariable variable, boolean useReferenceDirectly) {
        CompileStack compileStack = this.controller.getCompileStack();
        if (compileStack.isLHS()) {
            this.storeVar(variable);
        } else {
            MethodVisitor mv = this.controller.getMethodVisitor();
            int idx = variable.getIndex();
            ClassNode type = variable.getType();
            if (variable.isHolder()) {
                mv.visitVarInsn(25, idx);
                if (!useReferenceDirectly) {
                    mv.visitMethodInsn(182, "groovy/lang/Reference", "get", "()Ljava/lang/Object;");
                    BytecodeHelper.doCast(mv, type);
                    this.push(type);
                } else {
                    this.push(ClassHelper.REFERENCE_TYPE);
                }
            } else {
                this.load(type, idx);
            }
        }
    }

    public void storeVar(BytecodeVariable variable) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        int idx = variable.getIndex();
        ClassNode type = variable.getType();
        if (variable.isHolder()) {
            this.box();
            mv.visitVarInsn(25, idx);
            mv.visitTypeInsn(192, "groovy/lang/Reference");
            mv.visitInsn(95);
            mv.visitMethodInsn(182, "groovy/lang/Reference", "set", "(Ljava/lang/Object;)V");
        } else {
            this.doGroovyCast(type);
            if (type == ClassHelper.double_TYPE) {
                mv.visitVarInsn(57, idx);
            } else if (type == ClassHelper.float_TYPE) {
                mv.visitVarInsn(56, idx);
            } else if (type == ClassHelper.long_TYPE) {
                mv.visitVarInsn(55, idx);
            } else if (type == ClassHelper.boolean_TYPE || type == ClassHelper.char_TYPE || type == ClassHelper.byte_TYPE || type == ClassHelper.int_TYPE || type == ClassHelper.short_TYPE) {
                mv.visitVarInsn(54, idx);
            } else {
                mv.visitVarInsn(58, idx);
            }
        }
        this.remove(1);
    }

    public void load(ClassNode type, int idx) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        BytecodeHelper.load(mv, type, idx);
        this.push(type);
    }

    public void pushBool(boolean inclusive) {
        MethodVisitor mv = this.controller.getMethodVisitor();
        mv.visitLdcInsn(new Boolean(inclusive));
        this.push(ClassHelper.boolean_TYPE);
    }

    public String toString() {
        return "OperandStack(size=" + this.stack.size() + ":" + this.stack.toString() + ")";
    }

    public ClassNode getTopOperand() {
        int size = this.stack.size();
        try {
            if (size == 0) {
                throw new ArrayIndexOutOfBoundsException("size==0");
            }
        }
        catch (ArrayIndexOutOfBoundsException ai) {
            System.err.println("index problem in " + this.controller.getSourceUnit().getName());
            throw ai;
        }
        return this.stack.get(size - 1);
    }
}

