/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform;

import groovy.transform.AutoFinal;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.GroovyASTTransformation;

@GroovyASTTransformation(phase=CompilePhase.SEMANTIC_ANALYSIS)
public class AutoFinalASTTransformation
extends AbstractASTTransformation {
    private static final Class MY_CLASS = AutoFinal.class;
    private static final ClassNode MY_TYPE = ClassHelper.make(MY_CLASS);
    private static final String MY_TYPE_NAME = "@" + MY_TYPE.getNameWithoutPackage();

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        this.init(nodes, source);
        AnnotatedNode candidate = (AnnotatedNode)nodes[1];
        AnnotationNode node = (AnnotationNode)nodes[0];
        if (!MY_TYPE.equals(node.getClassNode())) {
            return;
        }
        if (candidate instanceof ClassNode) {
            this.processClass((ClassNode)candidate);
        } else if (candidate instanceof MethodNode) {
            this.processConstructorOrMethod((MethodNode)candidate);
        }
    }

    private void processClass(ClassNode cNode) {
        if (cNode.isInterface()) {
            this.addError("Error processing interface '" + cNode.getName() + "'. " + MY_TYPE_NAME + " only allowed for classes.", cNode);
            return;
        }
        for (ConstructorNode cn : cNode.getDeclaredConstructors()) {
            this.processConstructorOrMethod(cn);
        }
        for (MethodNode mn : cNode.getAllDeclaredMethods()) {
            this.processConstructorOrMethod(mn);
        }
    }

    private void processConstructorOrMethod(MethodNode node) {
        Parameter[] origParams;
        if (node.isSynthetic()) {
            return;
        }
        for (Parameter p : origParams = node.getParameters()) {
            p.setModifiers(p.getModifiers() | 0x10);
        }
    }
}

