/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ast.tools;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.PropertyNode;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MapExpression;
import org.codehaus.groovy.ast.expr.SpreadExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;

public class ClassNodeUtils {
    public static void addInterfaceMethods(ClassNode cnode, Map<String, MethodNode> methodsMap) {
        for (ClassNode iface : cnode.getInterfaces()) {
            Map<String, MethodNode> ifaceMethodsMap = iface.getDeclaredMethodsMap();
            for (String methSig : ifaceMethodsMap.keySet()) {
                if (methodsMap.containsKey(methSig)) continue;
                MethodNode methNode = ifaceMethodsMap.get(methSig);
                methodsMap.put(methSig, methNode);
            }
        }
    }

    public static Map<String, MethodNode> getDeclaredMethodMapsFromInterfaces(ClassNode classNode) {
        ClassNode[] interfaces;
        HashMap<String, MethodNode> result = new HashMap<String, MethodNode>();
        for (ClassNode iface : interfaces = classNode.getInterfaces()) {
            result.putAll(iface.getDeclaredMethodsMap());
        }
        return result;
    }

    public static void addDeclaredMethodMapsFromSuperInterfaces(ClassNode cn, Map<String, MethodNode> allInterfaceMethods) {
        List<ClassNode> cnInterfaces = Arrays.asList(cn.getInterfaces());
        for (ClassNode sn = cn.getSuperClass(); sn != null && !sn.equals(ClassHelper.OBJECT_TYPE); sn = sn.getSuperClass()) {
            ClassNode[] interfaces;
            for (ClassNode iface : interfaces = sn.getInterfaces()) {
                if (cnInterfaces.contains(iface)) continue;
                allInterfaceMethods.putAll(iface.getDeclaredMethodsMap());
            }
        }
    }

    public static boolean hasPossibleStaticMethod(ClassNode cNode, String name, Expression arguments, boolean trySpread) {
        int count = 0;
        boolean foundSpread = false;
        if (arguments instanceof TupleExpression) {
            TupleExpression tuple = (TupleExpression)arguments;
            for (Expression arg : tuple.getExpressions()) {
                if (arg instanceof SpreadExpression) {
                    foundSpread = true;
                    continue;
                }
                ++count;
            }
        } else if (arguments instanceof MapExpression) {
            count = 1;
        }
        for (MethodNode method : cNode.getMethods(name)) {
            if (!method.isStatic()) continue;
            Parameter[] parameters = method.getParameters();
            if (trySpread && foundSpread && parameters.length >= count) {
                return true;
            }
            if (parameters.length == count) {
                return true;
            }
            if (parameters.length > 0 && parameters[parameters.length - 1].getType().isArray()) {
                if (count >= parameters.length - 1) {
                    return true;
                }
                if (trySpread && foundSpread) {
                    return true;
                }
            }
            int nonDefaultParameters = 0;
            for (Parameter parameter : parameters) {
                if (parameter.hasInitialExpression()) continue;
                ++nonDefaultParameters;
            }
            if (count >= parameters.length || nonDefaultParameters > count) continue;
            return true;
        }
        return false;
    }

    public static boolean hasPossibleStaticProperty(ClassNode candidate, String methodName) {
        if (!methodName.startsWith("get") && !methodName.startsWith("is")) {
            return false;
        }
        String propName = ClassNodeUtils.getPropNameForAccessor(methodName);
        PropertyNode pNode = ClassNodeUtils.getStaticProperty(candidate, propName);
        return pNode != null && (methodName.startsWith("get") || ClassHelper.boolean_TYPE.equals(pNode.getType()));
    }

    public static String getPropNameForAccessor(String accessorName) {
        if (!ClassNodeUtils.isValidAccessorName(accessorName)) {
            return accessorName;
        }
        int prefixLength = accessorName.startsWith("is") ? 2 : 3;
        return String.valueOf(accessorName.charAt(prefixLength)).toLowerCase() + accessorName.substring(prefixLength + 1);
    }

    public static boolean isValidAccessorName(String accessorName) {
        if (accessorName.startsWith("get") || accessorName.startsWith("is") || accessorName.startsWith("set")) {
            int prefixLength = accessorName.startsWith("is") ? 2 : 3;
            return accessorName.length() > prefixLength;
        }
        return false;
    }

    public static boolean hasStaticProperty(ClassNode cNode, String propName) {
        return ClassNodeUtils.getStaticProperty(cNode, propName) != null;
    }

    public static PropertyNode getStaticProperty(ClassNode cNode, String propName) {
        for (ClassNode classNode = cNode; classNode != null; classNode = classNode.getSuperClass()) {
            for (PropertyNode pn : classNode.getProperties()) {
                if (!pn.getName().equals(propName) || !pn.isStatic()) continue;
                return pn;
            }
        }
        return null;
    }

    public static boolean isInnerClass(ClassNode currentClass) {
        return currentClass.redirect().getOuterClass() != null && !Modifier.isStatic(currentClass.getModifiers());
    }
}

