/*
 * Decompiled with CFR 0.152.
 */
package groovy.transform.builder;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.InnerClassNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.tools.GeneralUtils;
import org.codehaus.groovy.ast.tools.GenericsUtils;
import org.codehaus.groovy.transform.AbstractASTTransformation;
import org.codehaus.groovy.transform.BuilderASTTransformation;

public class DefaultStrategy
extends BuilderASTTransformation.AbstractBuilderStrategy {
    private static final Expression DEFAULT_INITIAL_VALUE = null;

    @Override
    public void build(BuilderASTTransformation transform, AnnotatedNode annotatedNode, AnnotationNode anno) {
        if (annotatedNode instanceof ClassNode) {
            this.buildClass(transform, (ClassNode)annotatedNode, anno);
        } else if (annotatedNode instanceof MethodNode) {
            this.buildMethod(transform, (MethodNode)annotatedNode, anno);
        }
    }

    public void buildMethod(BuilderASTTransformation transform, MethodNode mNode, AnnotationNode anno) {
        if (transform.getMemberValue(anno, "includes") != null || transform.getMemberValue(anno, "includes") != null) {
            transform.addError("Error during " + BuilderASTTransformation.MY_TYPE_NAME + " processing: includes/excludes only allowed on classes", anno);
        }
        String prefix = transform.getMemberStringValue(anno, "prefix", "");
        if (this.unsupportedAttribute(transform, anno, "forClass")) {
            return;
        }
        int visibility = 9;
        ClassNode buildee = mNode.getDeclaringClass();
        String builderClassName = transform.getMemberStringValue(anno, "builderClassName", buildee.getName() + "Builder");
        String fullName = buildee.getName() + "$" + builderClassName;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 9, ClassHelper.OBJECT_TYPE);
        buildee.getModule().addClass(builder);
        buildee.addMethod(DefaultStrategy.createBuilderMethod(transform, anno, builder));
        for (Parameter parameter : mNode.getParameters()) {
            builder.addField(DefaultStrategy.createFieldCopy(buildee, parameter));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(parameter.getName(), parameter.getType()), prefix));
        }
        builder.addMethod(this.createBuildMethodForMethod(transform, anno, buildee, mNode, mNode.getParameters()));
    }

    public void buildClass(BuilderASTTransformation transform, ClassNode buildee, AnnotationNode anno) {
        ArrayList<String> excludes = new ArrayList<String>();
        ArrayList<String> includes = new ArrayList<String>();
        if (!this.getIncludeExclude(transform, anno, buildee, excludes, includes)) {
            return;
        }
        String prefix = transform.getMemberStringValue(anno, "prefix", "");
        if (this.unsupportedAttribute(transform, anno, "forClass")) {
            return;
        }
        int visibility = 9;
        String builderClassName = transform.getMemberStringValue(anno, "builderClassName", buildee.getName() + "Builder");
        String fullName = buildee.getName() + "$" + builderClassName;
        InnerClassNode builder = new InnerClassNode(buildee, fullName, 9, ClassHelper.OBJECT_TYPE);
        buildee.getModule().addClass(builder);
        buildee.addMethod(DefaultStrategy.createBuilderMethod(transform, anno, builder));
        List<FieldNode> fields = GeneralUtils.getInstancePropertyFields(buildee);
        List<FieldNode> filteredFields = DefaultStrategy.selectFieldsFromExistingClass(fields, includes, excludes);
        for (FieldNode fieldNode : filteredFields) {
            builder.addField(DefaultStrategy.createFieldCopy(buildee, fieldNode));
            builder.addMethod(this.createBuilderMethodForProp(builder, new BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo(fieldNode.getName(), fieldNode.getType()), prefix));
        }
        builder.addMethod(DefaultStrategy.createBuildMethod(transform, anno, buildee, filteredFields));
    }

    private MethodNode createBuildMethodForMethod(BuilderASTTransformation transform, AnnotationNode anno, ClassNode buildee, MethodNode mNode, Parameter[] params) {
        ClassNode returnType;
        String buildMethodName = transform.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body = new BlockStatement();
        if (mNode instanceof ConstructorNode) {
            returnType = GenericsUtils.newClass(buildee);
            body.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(GenericsUtils.newClass(mNode.getDeclaringClass()), GeneralUtils.args(params))));
        } else {
            body.addStatement(GeneralUtils.returnS(GeneralUtils.callX(GenericsUtils.newClass(mNode.getDeclaringClass()), mNode.getName(), (Expression)GeneralUtils.args(params))));
            returnType = GenericsUtils.newClass(mNode.getReturnType());
        }
        return new MethodNode(buildMethodName, 1, returnType, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static MethodNode createBuilderMethod(BuilderASTTransformation transform, AnnotationNode anno, ClassNode builder) {
        String builderMethodName = transform.getMemberStringValue(anno, "builderMethodName", "builder");
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.returnS(GeneralUtils.ctorX(builder)));
        int visibility = 9;
        return new MethodNode(builderMethodName, 9, builder, BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private static MethodNode createBuildMethod(BuilderASTTransformation transform, AnnotationNode anno, ClassNode buildee, List<FieldNode> fields) {
        String buildMethodName = transform.getMemberStringValue(anno, "buildMethodName", "build");
        BlockStatement body = new BlockStatement();
        body.addStatement(GeneralUtils.returnS(DefaultStrategy.initializeInstance(buildee, fields, body)));
        return new MethodNode(buildMethodName, 1, GenericsUtils.newClass(buildee), BuilderASTTransformation.NO_PARAMS, BuilderASTTransformation.NO_EXCEPTIONS, body);
    }

    private MethodNode createBuilderMethodForProp(ClassNode builder, BuilderASTTransformation.AbstractBuilderStrategy.PropertyInfo pinfo, String prefix) {
        String fieldName = pinfo.getName();
        String setterName = this.getSetterName(prefix, fieldName);
        return new MethodNode(setterName, 1, GenericsUtils.newClass(builder), GeneralUtils.params(GeneralUtils.param(pinfo.getType(), fieldName)), BuilderASTTransformation.NO_EXCEPTIONS, GeneralUtils.block(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)GeneralUtils.varX("this"), GeneralUtils.constX(fieldName)), GeneralUtils.varX(fieldName))), GeneralUtils.returnS(GeneralUtils.varX("this", builder))));
    }

    private static FieldNode createFieldCopy(ClassNode buildee, Parameter param) {
        return new FieldNode(param.getName(), 2, ClassHelper.make(param.getType().getName()), buildee, param.getInitialExpression());
    }

    private static FieldNode createFieldCopy(ClassNode buildee, FieldNode fNode) {
        return new FieldNode(fNode.getName(), 2, ClassHelper.make(fNode.getType().getName()), buildee, DEFAULT_INITIAL_VALUE);
    }

    private static List<FieldNode> selectFieldsFromExistingClass(List<FieldNode> fieldNodes, List<String> includes, List<String> excludes) {
        ArrayList<FieldNode> fields = new ArrayList<FieldNode>();
        for (FieldNode fNode : fieldNodes) {
            if (AbstractASTTransformation.shouldSkip(fNode.getName(), excludes, includes)) continue;
            fields.add(fNode);
        }
        return fields;
    }

    private static Expression initializeInstance(ClassNode buildee, List<FieldNode> fields, BlockStatement body) {
        VariableExpression instance = GeneralUtils.varX("_the" + buildee.getNameWithoutPackage(), buildee);
        body.addStatement(GeneralUtils.declS(instance, GeneralUtils.ctorX(buildee)));
        for (FieldNode field : fields) {
            body.addStatement(GeneralUtils.stmt(GeneralUtils.assignX(GeneralUtils.propX((Expression)instance, field.getName()), GeneralUtils.varX(field))));
        }
        return instance;
    }
}

