/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx;

import griffon.core.ExceptionHandler;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.codehaus.griffon.runtime.core.threading.AbstractUIThreadManager;

public class JavaFXUIThreadManager
extends AbstractUIThreadManager {
    @Inject
    private ExceptionHandler exceptionHandler;

    public boolean isUIThread() {
        return Platform.isFxApplicationThread();
    }

    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Argument 'runnable' must not be null");
        Platform.runLater((Runnable)runnable);
    }

    public void runInsideUISync(final @Nonnull Runnable runnable) {
        Objects.requireNonNull(runnable, "Argument 'runnable' must not be null");
        if (this.isUIThread()) {
            runnable.run();
        } else {
            FutureTask<Object> task = new FutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        JavaFXUIThreadManager.this.exceptionHandler.uncaughtException(Thread.currentThread(), throwable);
                    }
                }
            }, null);
            Platform.runLater(task);
            try {
                task.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.exceptionHandler.uncaughtException(Thread.currentThread(), (Throwable)e);
            }
        }
    }
}

