/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.javafx;

import griffon.core.GriffonApplication;
import griffon.core.view.WindowDisplayHandler;
import griffon.exceptions.InstanceNotFoundException;
import griffon.javafx.JavaFXWindowDisplayHandler;
import griffon.util.AnnotationUtils;
import java.lang.annotation.Annotation;
import javafx.stage.Window;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.view.ConfigurableWindowDisplayHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurableJavaFXWindowDisplayHandler
extends ConfigurableWindowDisplayHandler<Window>
implements JavaFXWindowDisplayHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ConfigurableJavaFXWindowDisplayHandler.class);

    @Inject
    public ConfigurableJavaFXWindowDisplayHandler(@Nonnull GriffonApplication application, @Nonnull @Named(value="defaultWindowDisplayHandler") JavaFXWindowDisplayHandler delegateWindowsDisplayHandler) {
        super(application, (WindowDisplayHandler)delegateWindowsDisplayHandler);
    }

    @Nonnull
    protected JavaFXWindowDisplayHandler fetchDefaultWindowDisplayHandler() {
        Object handler = this.windowManagerBlock().get("defaultHandler");
        return (JavaFXWindowDisplayHandler)(handler instanceof JavaFXWindowDisplayHandler ? handler : this.getDelegateWindowsDisplayHandler());
    }

    protected boolean handleShowByInjectedHandler(@Nonnull String name, @Nonnull Window window) {
        try {
            JavaFXWindowDisplayHandler handler = (JavaFXWindowDisplayHandler)this.getApplication().getInjector().getInstance(JavaFXWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
            LOG.trace("Showing {} with injected handler", (Object)name);
            handler.show(name, window);
            return true;
        }
        catch (InstanceNotFoundException infe) {
            return super.handleShowByInjectedHandler(name, (Object)window);
        }
    }

    protected boolean handleHideByInjectedHandler(@Nonnull String name, @Nonnull Window window) {
        try {
            JavaFXWindowDisplayHandler handler = (JavaFXWindowDisplayHandler)this.getApplication().getInjector().getInstance(JavaFXWindowDisplayHandler.class, (Annotation)AnnotationUtils.named((String)name));
            LOG.trace("Hiding {} with injected handler", (Object)name);
            handler.hide(name, window);
            return true;
        }
        catch (InstanceNotFoundException infe) {
            return super.handleHideByInjectedHandler(name, (Object)window);
        }
    }
}

