/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.RadialGradient;

public class RadialGradientPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        return this.getValueInternal().toString();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value).trim());
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof RadialGradient) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, RadialGradient.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        try {
            super.setValueInternal((Object)RadialGradient.valueOf((String)str));
        }
        catch (Exception e) {
            throw this.illegalValue(str, RadialGradient.class, e);
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double fa = 0.0;
        double fd = 0.0;
        double cx = 0.0;
        double cy = 0.0;
        double r = 0.0;
        boolean proportional = false;
        List stops = new ArrayList();
        CycleMethod cyclicMethod = CycleMethod.NO_CYCLE;
        switch (list.size()) {
            case 8: {
                cyclicMethod = this.parseCyclicMethod(list, String.valueOf(list.get(7)).trim());
            }
            case 7: {
                fa = this.parseValue(list.get(0));
                fd = this.parseValue(list.get(1));
                cx = this.parseValue(list.get(2));
                cy = this.parseValue(list.get(3));
                r = this.parseValue(list.get(4));
                proportional = (Boolean)list.get(5);
                stops = (List)list.get(6);
                super.setValueInternal((Object)new RadialGradient(fa, fd, cx, cy, r, proportional, cyclicMethod, stops));
                break;
            }
            default: {
                throw this.illegalValue(list, RadialGradient.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        Object cyclicValue;
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double fa = (Double)this.getMapValue(map, "fa", 0.0);
        double fd = (Double)this.getMapValue(map, "fd", 0.0);
        double cx = (Double)this.getMapValue(map, "cx", 0.0);
        double cy = (Double)this.getMapValue(map, "cy", 0.0);
        double r = (Double)this.getMapValue(map, "r", 0.0);
        boolean proportional = (Boolean)this.getMapValue(map, "p", false);
        List stops = new ArrayList();
        CycleMethod cyclicMethod = CycleMethod.NO_CYCLE;
        if (map.containsKey("stops")) {
            stops = (List)map.get("stops");
        }
        if (null != (cyclicValue = map.get("cycle"))) {
            cyclicMethod = this.parseCyclicMethod(map, String.valueOf(cyclicValue));
        }
        super.setValueInternal((Object)new RadialGradient(fa, fd, cx, cy, r, proportional, cyclicMethod, stops));
    }

    protected CycleMethod parseCyclicMethod(Object source, String str) {
        try {
            Field cyclicMethodField = CycleMethod.class.getDeclaredField(str.toUpperCase().trim());
            return (CycleMethod)cyclicMethodField.get(null);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw this.illegalValue(source, RadialGradient.class, e);
        }
    }

    protected double parse(String val) {
        try {
            return Float.parseFloat(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, RadialGradient.class, e);
        }
    }

    protected double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, RadialGradient.class);
    }

    protected double parse(Number val) {
        return val.doubleValue();
    }

    protected Object getMapValue(Map<?, ?> map, String key, Object defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, RadialGradient.class);
    }
}

