/*
 * Decompiled with CFR 0.152.
 */
package griffon.javafx.editors;

import griffon.core.editors.AbstractPropertyEditor;
import griffon.util.GriffonNameUtils;
import java.util.List;
import java.util.Map;
import javafx.geometry.Dimension2D;

public class Dimension2DPropertyEditor
extends AbstractPropertyEditor {
    public String getAsText() {
        if (null == this.getValue()) {
            return null;
        }
        Dimension2D dimension = (Dimension2D)this.getValue();
        return dimension.getWidth() + ", " + dimension.getHeight();
    }

    protected void setValueInternal(Object value) {
        if (null == value) {
            super.setValueInternal(null);
        } else if (value instanceof CharSequence) {
            this.handleAsString(String.valueOf(value));
        } else if (value instanceof List) {
            this.handleAsList((List)value);
        } else if (value instanceof Map) {
            this.handleAsMap((Map)value);
        } else if (value instanceof Number) {
            this.handleAsNumber((Number)value);
        } else if (value instanceof Dimension2D) {
            super.setValueInternal(value);
        } else {
            throw this.illegalValue(value, Dimension2D.class);
        }
    }

    protected void handleAsString(String str) {
        if (GriffonNameUtils.isBlank((String)str)) {
            super.setValueInternal(null);
            return;
        }
        String[] parts = str.split(",");
        switch (parts.length) {
            case 1: {
                double s = this.parseValue(parts[0]);
                super.setValueInternal((Object)new Dimension2D(s, s));
                break;
            }
            case 2: {
                double w = this.parseValue(parts[0]);
                double h = this.parseValue(parts[1]);
                super.setValueInternal((Object)new Dimension2D(w, h));
                break;
            }
            default: {
                throw this.illegalValue(str, Dimension2D.class);
            }
        }
    }

    protected void handleAsList(List<?> list) {
        if (list.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        switch (list.size()) {
            case 1: {
                double s = this.parseValue(list.get(0));
                super.setValueInternal((Object)new Dimension2D(s, s));
                break;
            }
            case 2: {
                double w = this.parseValue(list.get(0));
                double h = this.parseValue(list.get(1));
                super.setValueInternal((Object)new Dimension2D(w, h));
                break;
            }
            default: {
                throw this.illegalValue(list, Dimension2D.class);
            }
        }
    }

    protected void handleAsMap(Map<?, ?> map) {
        if (map.isEmpty()) {
            super.setValueInternal(null);
            return;
        }
        double w = this.getMapValue(map, "width", 0.0);
        double h = this.getMapValue(map, "height", 0.0);
        super.setValueInternal((Object)new Dimension2D(w, h));
    }

    protected double parseValue(Object value) {
        if (value instanceof CharSequence) {
            return this.parse(String.valueOf(value));
        }
        if (value instanceof Number) {
            return this.parse((Number)value);
        }
        throw this.illegalValue(value, Dimension2D.class);
    }

    protected double parse(String val) {
        try {
            return Double.parseDouble(val.trim());
        }
        catch (NumberFormatException e) {
            throw this.illegalValue(val, Dimension2D.class, e);
        }
    }

    protected double parse(Number val) {
        return val.doubleValue();
    }

    protected double getMapValue(Map<?, ?> map, String key, double defaultValue) {
        Object val = map.get(key);
        if (null == val) {
            val = map.get(String.valueOf(key.charAt(0)));
        }
        if (null == val) {
            return defaultValue;
        }
        if (val instanceof CharSequence) {
            return this.parse(String.valueOf(val));
        }
        if (val instanceof Number) {
            return this.parse((Number)val);
        }
        throw this.illegalValue(map, Dimension2D.class);
    }

    protected void handleAsNumber(Number value) {
        double s = this.parse(value);
        super.setValueInternal((Object)new Dimension2D(s, s));
    }
}

