/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy.artifact;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonArtifact;
import griffon.core.artifact.GriffonClass;
import griffon.core.artifact.GriffonController;
import griffon.core.artifact.GriffonModel;
import griffon.core.artifact.GriffonMvcArtifact;
import griffon.core.artifact.GriffonView;
import griffon.core.mvc.MVCFunction;
import griffon.core.mvc.MVCGroup;
import groovy.lang.Script;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGriffonArtifactScript
extends Script
implements GriffonArtifact {
    private final Logger log;
    private final Object lock = new Object[0];
    @Inject
    protected GriffonApplication application;
    @GuardedBy(value="lock")
    private GriffonClass griffonClass;

    public AbstractGriffonArtifactScript() {
        this.log = LoggerFactory.getLogger((String)("griffon.app." + this.getArtifactType() + "." + ((Object)((Object)this)).getClass().getName()));
    }

    @Nonnull
    public GriffonApplication getApplication() {
        return this.application;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public GriffonClass getGriffonClass() {
        Object object = this.lock;
        synchronized (object) {
            if (this.griffonClass == null) {
                this.griffonClass = this.application.getArtifactManager().findGriffonClass(((Object)((Object)this)).getClass());
            }
            return this.griffonClass;
        }
    }

    @Nonnull
    public Logger getLog() {
        return this.log;
    }

    @Nonnull
    protected abstract String getArtifactType();

    public boolean isUIThread() {
        return this.application.getUIThreadManager().isUIThread();
    }

    @Nonnull
    public <R> Future<R> runFuture(@Nonnull ExecutorService executorService, @Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(executorService, callable);
    }

    @Nonnull
    public <R> Future<R> runFuture(@Nonnull Callable<R> callable) {
        return this.application.getUIThreadManager().runFuture(callable);
    }

    public void runInsideUISync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUISync(runnable);
    }

    public void runOutsideUI(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runOutsideUI(runnable);
    }

    public void runInsideUIAsync(@Nonnull Runnable runnable) {
        this.application.getUIThreadManager().runInsideUIAsync(runnable);
    }

    @Nullable
    public <R> R runInsideUISync(@Nonnull Callable<R> callable) {
        return (R)this.application.getUIThreadManager().runInsideUISync(callable);
    }

    @Nonnull
    public ClassLoader classloader() {
        return this.application.getResourceHandler().classloader();
    }

    @Nullable
    public URL getResourceAsURL(@Nonnull String name) {
        return this.application.getResourceHandler().getResourceAsURL(name);
    }

    @Nullable
    public List<URL> getResources(@Nonnull String name) {
        return this.application.getResourceHandler().getResources(name);
    }

    @Nullable
    public InputStream getResourceAsStream(@Nonnull String name) {
        return this.application.getResourceHandler().getResourceAsStream(name);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> args, @Nonnull String mvcType) {
        return this.application.getMvcGroupManager().createMVCGroup(args, mvcType);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String mvcType) {
        return this.application.getMvcGroupManager().createMVC(mvcType);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String mvcType, @Nonnull String mvcId, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(mvcType, mvcId, handler);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String mvcType, @Nonnull String mvcId) {
        return this.application.getMvcGroupManager().createMVC(mvcType, mvcId);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> args, @Nonnull String mvcType, @Nonnull String mvcId) {
        return this.application.getMvcGroupManager().createMVC(args, mvcType, mvcId);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> args, @Nonnull String mvcType, @Nonnull String mvcId, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(args, mvcType, mvcId, handler);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull Map<String, Object> args, @Nonnull String mvcType, @Nonnull String mvcId) {
        return this.application.getMvcGroupManager().createMVCGroup(args, mvcType, mvcId);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String mvcType, @Nonnull String mvcId, @Nonnull Map<String, Object> args) {
        return this.application.getMvcGroupManager().createMVCGroup(mvcType, mvcId, args);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull Map<String, Object> args, @Nonnull String mvcType) {
        return this.application.getMvcGroupManager().createMVC(args, mvcType);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String mvcType, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(mvcType, handler);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String mvcType) {
        return this.application.getMvcGroupManager().createMVCGroup(mvcType);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String mvcType, @Nonnull String mvcId) {
        return this.application.getMvcGroupManager().createMVCGroup(mvcType, mvcId);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String mvcType, @Nonnull Map<String, Object> args) {
        return this.application.getMvcGroupManager().createMVC(mvcType, args);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull Map<String, Object> args, @Nonnull String mvcType, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(args, mvcType, handler);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String mvcType, @Nonnull Map<String, Object> args, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(mvcType, args, handler);
    }

    @Nonnull
    public MVCGroup createMVCGroup(@Nonnull String mvcType, @Nonnull Map<String, Object> args) {
        return this.application.getMvcGroupManager().createMVCGroup(mvcType, args);
    }

    @Nonnull
    public List<? extends GriffonMvcArtifact> createMVC(@Nonnull String mvcType, @Nonnull String mvcId, @Nonnull Map<String, Object> args) {
        return this.application.getMvcGroupManager().createMVC(mvcType, mvcId, args);
    }

    public <M extends GriffonModel, V extends GriffonView, C extends GriffonController> void withMVC(@Nonnull String mvcType, @Nonnull String mvcId, @Nonnull Map<String, Object> args, @Nonnull MVCFunction<M, V, C> handler) {
        this.application.getMvcGroupManager().withMVC(mvcType, mvcId, args, handler);
    }

    public void destroyMVCGroup(@Nonnull String mvcId) {
        this.application.getMvcGroupManager().destroyMVCGroup(mvcId);
    }
}

