/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.griffon.runtime.groovy;

import griffon.core.GriffonApplication;
import griffon.core.artifact.GriffonController;
import griffon.core.controller.Action;
import griffon.core.mvc.MVCGroup;
import griffon.core.mvc.MVCGroupConfiguration;
import groovy.util.FactoryBuilderSupport;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import org.codehaus.griffon.runtime.core.addon.AbstractGriffonAddon;

@Named(value="groovy")
public class GroovyAddon
extends AbstractGriffonAddon {
    private GriffonApplication application;

    public void init(@Nonnull GriffonApplication application) {
        this.application = application;
    }

    public void onInitializeMVCGroup(@Nonnull MVCGroupConfiguration configuration, @Nonnull MVCGroup group) {
        GriffonController controller = group.getController();
        if (controller == null) {
            return;
        }
        FactoryBuilderSupport builder = (FactoryBuilderSupport)group.getMember("builder");
        if (builder == null) {
            return;
        }
        Map actions = this.application.getActionManager().actionsFor(controller);
        for (Map.Entry action : actions.entrySet()) {
            String actionKey = this.application.getActionManager().normalizeName((String)action.getKey()) + "Action";
            this.getLog().trace("Adding action {} to {}:{}:builder", new Object[]{actionKey, configuration.getMvcType(), group.getMvcId()});
            builder.setVariable(actionKey, ((Action)action.getValue()).getToolkitAction());
        }
    }
}

