/*
 * Decompiled with CFR 0.152.
 */
package griffon.util;

import griffon.util.BuilderCustomizer;
import groovy.lang.Closure;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import groovy.util.Factory;
import groovy.util.FactoryBuilderSupport;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CompositeBuilder
extends FactoryBuilderSupport {
    public CompositeBuilder(@Nonnull BuilderCustomizer[] customizers) {
        super(false);
        Objects.requireNonNull(customizers, "Argument 'customizers' must not be null");
        for (int i = 0; i < customizers.length; ++i) {
            BuilderCustomizer customizer = customizers[customizers.length - 1 - i];
            this.doRegisterVariables(customizer);
            this.doRegisterFactories(customizer);
            this.doRegisterMethods(customizer);
            this.doRegisterProps(customizer);
        }
        final ArrayList<Closure> methodMissingDelegates = new ArrayList<Closure>();
        final ArrayList<Closure> propertyMissingDelegates = new ArrayList<Closure>();
        for (BuilderCustomizer customizer : customizers) {
            this.doRegisterAttributeDelegates(customizer);
            this.doRegisterPreInstantiateDelegates(customizer);
            this.doRegisterPostInstantiateDelegates(customizer);
            this.doRegisterPostNodeCompletionDelegates(customizer);
            this.doDisposalClosures(customizer);
            if (customizer.getMethodMissingDelegate() != null) {
                methodMissingDelegates.add(customizer.getMethodMissingDelegate());
            }
            if (customizer.getPropertyMissingDelegate() == null) continue;
            propertyMissingDelegates.add(customizer.getPropertyMissingDelegate());
        }
        final Closure originalMethodMissingDelegate = this.getMethodMissingDelegate();
        this.setMethodMissingDelegate((Closure)new Closure<Object>((Object)this){
            private static final long serialVersionUID = -6901410680736336645L;

            protected Object doCall(Object[] args) {
                String methodName;
                block6: {
                    methodName = String.valueOf(args[0]);
                    for (Closure methodMissingDelegate : methodMissingDelegates) {
                        try {
                            return methodMissingDelegate.call(args);
                        }
                        catch (MissingMethodException mme) {
                            if (methodName.equals(mme.getMethod())) continue;
                            throw mme;
                        }
                    }
                    if (originalMethodMissingDelegate != null) {
                        try {
                            return originalMethodMissingDelegate.call(args);
                        }
                        catch (MissingMethodException mme) {
                            if (methodName.equals(mme.getMethod())) break block6;
                            throw mme;
                        }
                    }
                }
                Object[] argsCopy = new Object[args.length - 1];
                System.arraycopy(args, 1, argsCopy, 0, argsCopy.length);
                throw new MissingMethodException(methodName, CompositeBuilder.class, argsCopy);
            }
        });
        final Closure originalPropertyMissingDelegate = this.getMethodMissingDelegate();
        this.setPropertyMissingDelegate((Closure)new Closure<Object>((Object)this){
            private static final long serialVersionUID = 1055591497264374109L;

            protected Object doCall(Object[] args) {
                String propertyName;
                block6: {
                    propertyName = String.valueOf(args[0]);
                    for (Closure propertyMissingDelegate : propertyMissingDelegates) {
                        try {
                            return propertyMissingDelegate.call(args);
                        }
                        catch (MissingMethodException mme) {
                            if (propertyName.equals(mme.getMethod())) continue;
                            throw mme;
                        }
                    }
                    if (originalPropertyMissingDelegate != null) {
                        try {
                            return originalPropertyMissingDelegate.call(args);
                        }
                        catch (MissingMethodException mme) {
                            if (propertyName.equals(mme.getMethod())) break block6;
                            throw mme;
                        }
                    }
                }
                throw new MissingPropertyException(propertyName, CompositeBuilder.class);
            }
        });
    }

    private void doRegisterVariables(@Nonnull BuilderCustomizer customizer) {
        for (Map.Entry<String, Object> entry : customizer.getVariables().entrySet()) {
            this.setVariable(entry.getKey(), entry.getValue());
        }
    }

    private void doRegisterFactories(@Nonnull BuilderCustomizer customizer) {
        for (Map.Entry<String, Factory> entry : customizer.getFactories().entrySet()) {
            this.registerFactory(entry.getKey(), entry.getValue());
        }
    }

    private void doRegisterMethods(@Nonnull BuilderCustomizer customizer) {
        for (Map.Entry<String, Closure> e : customizer.getMethods().entrySet()) {
            this.registerExplicitMethod(e.getKey(), e.getValue());
        }
    }

    private void doRegisterProps(@Nonnull BuilderCustomizer customizer) {
        for (Map.Entry<String, Closure[]> entry : customizer.getProps().entrySet()) {
            Closure[] accessors = entry.getValue();
            Closure getter = accessors[0];
            Closure setter = accessors[1];
            this.registerExplicitProperty(entry.getKey(), getter, setter);
        }
    }

    private void doRegisterAttributeDelegates(@Nonnull BuilderCustomizer customizer) {
        for (Closure c : customizer.getAttributeDelegates()) {
            this.addAttributeDelegate(c);
        }
    }

    private void doRegisterPreInstantiateDelegates(@Nonnull BuilderCustomizer customizer) {
        for (Closure c : customizer.getPreInstantiateDelegates()) {
            this.addPreInstantiateDelegate(c);
        }
    }

    private void doRegisterPostInstantiateDelegates(@Nonnull BuilderCustomizer customizer) {
        for (Closure c : customizer.getPostInstantiateDelegates()) {
            this.addPostInstantiateDelegate(c);
        }
    }

    private void doRegisterPostNodeCompletionDelegates(@Nonnull BuilderCustomizer customizer) {
        for (Closure c : customizer.getPostNodeCompletionDelegates()) {
            this.addPostNodeCompletionDelegate(c);
        }
    }

    private void doDisposalClosures(@Nonnull BuilderCustomizer customizer) {
        for (Closure c : customizer.getDisposalClosures()) {
            this.addDisposalClosure(c);
        }
    }
}

